/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import nex.village.PigtificateVillageData;

public class PigtificateVillageManager {
    private static final Map<Integer, PigtificateVillageData> PIGTIFICATE_VILLAGE_DATA = new HashMap<Integer, PigtificateVillageData>();

    public static void loadVillageData(World world) {
        if (!PigtificateVillageManager.hasData(world)) {
            PigtificateVillageManager.getVillageData(world, false);
        }
    }

    public static void unloadVillageData(World world) {
        PIGTIFICATE_VILLAGE_DATA.remove(world.field_73011_w.getDimension());
    }

    public static boolean hasData(World world) {
        return PIGTIFICATE_VILLAGE_DATA.containsKey(world.field_73011_w.getDimension());
    }

    public static PigtificateVillageData getVillageData(World world, boolean createData) {
        PigtificateVillageData data;
        int dimensionId = world.field_73011_w.getDimension();
        if (PigtificateVillageManager.hasData(world)) {
            data = PIGTIFICATE_VILLAGE_DATA.get(dimensionId);
        } else {
            String worldFile = PigtificateVillageData.getFileName(world);
            data = (PigtificateVillageData)world.getPerWorldStorage().func_75742_a(PigtificateVillageData.class, worldFile);
            if (data == null && createData) {
                data = new PigtificateVillageData(world);
                world.getPerWorldStorage().func_75745_a(worldFile, (WorldSavedData)data);
            }
        }
        if (data != null) {
            data.setWorld(world);
            PIGTIFICATE_VILLAGE_DATA.put(dimensionId, data);
        }
        return data;
    }
}

