/*
 * Decompiled with CFR 0.152.
 */
package nex;

import lex.IModData;
import lex.proxy.IProxy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.handler.ConfigHandler;
import nex.init.NetherExBiomes;
import nex.init.NetherExEntities;
import nex.init.NetherExFeatures;
import nex.init.NetherExOreDictionary;
import nex.init.NetherExRecipes;
import nex.init.NetherExVanillaOverrides;
import nex.village.PigtificateTradeManager;
import nex.world.biome.NetherExBiomeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="nex", name="NetherEx", version="2.0.8", dependencies="required-after:lex@[1.0.8,);", acceptedMinecraftVersions="[1.12.2]")
public class NetherEx
implements IModData {
    public static final String MOD_ID = "nex";
    public static final String NAME = "NetherEx";
    public static final String VERSION = "2.0.8";
    public static final String DEPENDENCIES = "required-after:lex@[1.0.8,);";
    private static final String CLIENT_PROXY = "nex.proxy.ClientProxy";
    private static final String SERVER_PROXY = "nex.proxy.ServerProxy";
    @Mod.Instance(value="nex")
    public static NetherEx instance;
    @SidedProxy(clientSide="nex.proxy.ClientProxy", serverSide="nex.proxy.ServerProxy")
    public static IProxy proxy;
    private static final CreativeTabs CREATIVE_TAB;
    public static final Logger LOGGER;

    @Mod.EventHandler
    public void onFMLPreInitialization(FMLPreInitializationEvent event) {
        ConfigHandler.preInit();
        NetherExBiomeManager.preInit();
        PigtificateTradeManager.preInit();
        NetherExEntities.preInit();
        NetherExVanillaOverrides.preInit();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        NetherExBiomes.init();
        NetherExRecipes.init();
        NetherExOreDictionary.init();
        NetherExFeatures.init();
        proxy.init();
    }

    @Mod.EventHandler
    public void onFMLPostInitialization(FMLPostInitializationEvent event) {
        NetherExVanillaOverrides.postInit();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void onFMLServerStarting(FMLServerStartingEvent event) {
        NetherExBiomeManager.setupDefaultBiomes();
        NetherExBiomeManager.setupCompatibleBiomes(event.getServer());
        NetherExBiomeManager.setupCustomBiomes();
        PigtificateTradeManager.setupDefaultTrades();
        PigtificateTradeManager.setupCustomTrades();
    }

    @Mod.EventHandler
    public void onFMLServerStopping(FMLServerStoppingEvent event) {
        NetherExBiomeManager.resetBiomes();
        PigtificateTradeManager.resetTrades();
    }

    public String getModId() {
        return MOD_ID;
    }

    public CreativeTabs getCreativeTab() {
        return CREATIVE_TAB;
    }

    static {
        CREATIVE_TAB = new CreativeTabs(MOD_ID){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(Blocks.field_150424_aL);
            }
        };
        LOGGER = LogManager.getLogger((String)NAME);
        FluidRegistry.enableUniversalBucket();
    }
}

