/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks.planetAndMoonBlocks;

import com.google.common.base.Predicate;
import com.mjr.extraplanets.ExtraPlanets;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBasicCallisto
extends Block
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock,
ISortableBlock {
    public static final PropertyEnum<EnumBlockBasic> BASIC_TYPE = PropertyEnum.func_177709_a((String)"basictypecallisto", EnumBlockBasic.class);

    public BlockBasicCallisto(String name) {
        super(Material.field_151576_e);
        this.func_149663_c(name);
        this.func_149647_a(ExtraPlanets.BlocksTab);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.STONE) {
            return 6.0f;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_COPPER || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_IRON || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_TIN) {
            return 3.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SURFACE || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SUB_SURFACE) {
            return 0.5f;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_COPPER || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_IRON || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_TIN) {
            return 5.0f;
        }
        return 1.5f;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumBlockBasic blockBasic : EnumBlockBasic.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockBasic.getMeta()));
        }
    }

    public boolean isValueable(IBlockState state) {
        EnumBlockBasic type = (EnumBlockBasic)((Object)state.func_177229_b(BASIC_TYPE));
        switch (type) {
            case ORE_IRON: 
            case ORE_TIN: 
            case ORE_COPPER: 
            case DRIED_OIL: 
            case SHALE_OIL: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(IBlockState arg0) {
        return false;
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        return state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SURFACE && !stateAbove.func_185917_h();
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        if (target != Blocks.field_150348_b) {
            return false;
        }
        return state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.STONE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumBlockBasic.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockBasic)((Object)state.func_177229_b(BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        switch (meta) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return EnumSortCategoryBlock.ORE;
            }
        }
        return EnumSortCategoryBlock.GENERAL;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SHALE_OIL) {
            if (this.canSilkHarvest(world, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                items.add(this.func_180643_i(state));
                ForgeEventFactory.fireBlockHarvesting(items, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
                for (ItemStack is : items) {
                    BlockBasicCallisto.func_180635_a((World)world, (BlockPos)pos, (ItemStack)is);
                }
            } else {
                String oilID = ConfigManagerCore.useOldOilFluidID ? "oilgc" : "oil";
                world.func_180501_a(pos, FluidRegistry.getFluid((String)oilID).getBlock().func_176223_P(), 1);
            }
        } else {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    public static enum EnumBlockBasic implements IStringSerializable
    {
        SURFACE(0, "callisto_surface"),
        SUB_SURFACE(1, "callisto_sub_surface"),
        STONE(2, "callisto_stone"),
        ORE_IRON(3, "callisto_ore_iron"),
        ORE_TIN(4, "callisto_ore_tin"),
        ORE_COPPER(5, "callisto_ore_copper"),
        DRIED_OIL(6, "callisto_dried_oil"),
        SHALE_OIL(7, "callisto_shale_oil");

        private final int meta;
        private final String name;

        private EnumBlockBasic(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockBasic byMetadata(int meta) {
            return EnumBlockBasic.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

