/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.util.resource.SpriteQuery;
import hellfirepvp.astralsorcery.client.util.resource.TextureQuery;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ResearchNode {
    private static int counter = 0;
    private final int id;
    private final RenderType renderType;
    public final int renderPosX;
    public final int renderPosZ;
    private String unlocName;
    private ItemStack[] renderItemStacks;
    private TextureQuery renderTextureQuery;
    private SpriteQuery renderSpriteQuery;
    private Color textureColorHint = new Color(-1, true);
    private List<ResearchNode> connectionsTo = new LinkedList<ResearchNode>();
    private List<IJournalPage> pages = new LinkedList<IJournalPage>();

    private ResearchNode(RenderType type, String unlocName, int rPosX, int rPosZ) {
        this.id = counter++;
        this.renderType = type;
        this.renderPosX = rPosX;
        this.renderPosZ = rPosZ;
        this.unlocName = unlocName;
    }

    public ResearchNode(ItemStack itemStack, String unlocName, int renderPosX, int renderPosZ) {
        this(RenderType.ITEMSTACK, unlocName, renderPosX, renderPosZ);
        this.renderItemStacks = new ItemStack[]{itemStack};
    }

    public ResearchNode(ItemStack[] stacks, String unlocName, int renderPosX, int renderPosZ) {
        this(RenderType.ITEMSTACK, unlocName, renderPosX, renderPosZ);
        this.renderItemStacks = stacks;
    }

    public ResearchNode(TextureQuery query, String unlocName, int renderPosX, int renderPosZ) {
        this(RenderType.TEXTURE, unlocName, renderPosX, renderPosZ);
        this.renderTextureQuery = query;
    }

    public ResearchNode(SpriteQuery query, String unlocName, int renderPosX, int renderPosZ) {
        this(RenderType.TEXTURE_SPRITE, unlocName, renderPosX, renderPosZ);
        this.renderSpriteQuery = query;
    }

    public ResearchNode addSourceConnectionFrom(ResearchNode node) {
        this.connectionsTo.add(node);
        return this;
    }

    public ResearchNode addSourceConnectionFrom(ResearchNode ... node) {
        return this.addSourceConnectionsFrom(Arrays.asList(node));
    }

    public ResearchNode addSourceConnectionsFrom(Collection<ResearchNode> node) {
        this.connectionsTo.addAll(node);
        return this;
    }

    public List<ResearchNode> getConnectionsTo() {
        return this.connectionsTo;
    }

    public ResearchNode addPage(IJournalPage page) {
        this.pages.add(page);
        return this;
    }

    public boolean canSee(@Nullable PlayerProgress progress) {
        return true;
    }

    public ResearchNode setTextureColorHintWithAlpha(Color textureColorHint) {
        this.textureColorHint = textureColorHint;
        return this;
    }

    public Color getTextureColorHint() {
        return this.textureColorHint;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public ItemStack getRenderItemStack() {
        return this.getRenderItemStack(0L);
    }

    public ItemStack getRenderItemStack(long tick) {
        return this.renderItemStacks[(int)(tick / 40L % (long)this.renderItemStacks.length)];
    }

    public TextureQuery getTexture() {
        return this.renderTextureQuery;
    }

    public SpriteQuery getSpriteTexture() {
        return this.renderSpriteQuery;
    }

    public List<IJournalPage> getPages() {
        return this.pages;
    }

    public String getUnLocalizedName() {
        return String.format("research.%s.name", this.unlocName);
    }

    public String getSimpleName() {
        return this.unlocName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResearchNode that = (ResearchNode)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static enum RenderType {
        ITEMSTACK,
        TEXTURE,
        TEXTURE_SPRITE;

    }
}

