/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStar;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReAttunementStarRecipe
extends TraitRecipe
implements ISpecialCraftingEffects {
    private final IMajorConstellation attuneCst;

    public ReAttunementStarRecipe(IMajorConstellation cst) {
        super(ReAttunementStarRecipe.shapedRecipe("shiftingstar/enhanced/" + cst.getSimpleName(), ItemShiftingStar.createStack(cst)).addPart(cst.getConstellationSignatureItems().get(0), ShapedRecipeSlot.UPPER_CENTER, ShapedRecipeSlot.LOWER_CENTER).addPart(ItemsAS.shiftingStar, ShapedRecipeSlot.CENTER).addPart(OreDictAlias.ITEM_STARMETAL_INGOT, ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT).unregisteredAccessibleShapedRecipe());
        this.setInnerTraitItem(OreDictAlias.ITEM_STARMETAL_DUST, TraitRecipe.TraitRecipeSlot.values());
        this.addOuterTraitItem(OreDictAlias.ITEM_STARMETAL_DUST);
        this.addOuterTraitItem(ItemUsableDust.DustType.ILLUMINATION.asStack());
        this.addOuterTraitItem(cst.getConstellationSignatureItems().get(0));
        this.addOuterTraitItem(OreDictAlias.ITEM_STARMETAL_DUST);
        this.addOuterTraitItem(ItemUsableDust.DustType.ILLUMINATION.asStack());
        this.addOuterTraitItem(cst.getConstellationSignatureItems().get(0));
        if (cst == null) {
            throw new IllegalArgumentException("NULL constellation passed to shifting-star enhancement recipe!");
        }
        this.attuneCst = cst;
        this.setRequiredConstellation(this.attuneCst);
    }

    @Override
    public AbstractAltarRecipe copyNewEffectInstance() {
        return new ReAttunementStarRecipe(this.attuneCst);
    }

    @Override
    public boolean needsStrictMatching() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        EffectLightbeam lightbeam;
        super.onCraftClientTick(altar, state, tick, rand);
        if (state != ActiveCraftingTask.CraftingState.ACTIVE) {
            return;
        }
        float total = 180.0f;
        float percCycle = (float)((double)((float)tick % total / total * 2.0f) * Math.PI);
        int parts = 5;
        Vector3 center = new Vector3(altar).add(0.5, 0.1, 0.5);
        float angleSwirl = 70.0f;
        float dst = 3.5f;
        for (int i = 0; i < parts; ++i) {
            Vector3 v = new Vector3(1, 0, 0);
            float originalAngle = (float)i / (float)parts * 360.0f;
            double angle = originalAngle + MathHelper.func_76126_a((float)percCycle) * angleSwirl;
            v.rotate(-Math.toRadians(angle), Vector3.RotAxis.Y_AXIS).normalize().multiply(dst);
            Vector3 pos = center.clone().add(v);
            Vector3 mot = center.clone().subtract(pos).normalize().multiply(0.07);
            EntityFXFacingParticle particle = this.playParticle(pos, rand);
            particle.motion(mot.getX(), mot.getY(), mot.getZ());
        }
        float partDone = (float)tick % total / total;
        float xSh = partDone >= 0.5f ? 1.0f : partDone / 0.5f;
        float zSh = partDone < 0.5f ? 1.0f : 1.0f - (partDone - 0.5f) / 0.5f;
        Vector3 offset = new Vector3(altar).add(-3.0, 0.1, -3.0);
        offset.add(xSh * 7.0f, 0.0, zSh * 7.0f);
        EntityFXFacingParticle particle = this.playParticle(offset, rand);
        particle.scale(0.1f + rand.nextFloat() * 0.5f);
        particle.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        if (rand.nextInt(12) == 0) {
            lightbeam = EffectHandler.getInstance().lightbeam(offset.clone().addY(3 + rand.nextInt(2)), offset, 1.0);
            lightbeam.setMaxAge(48);
            if (rand.nextInt(4) == 0) {
                lightbeam.setColorOverlay(Color.WHITE);
            } else if (rand.nextInt(3) == 0) {
                lightbeam.setColorOverlay(this.attuneCst.getConstellationColor().brighter());
            } else {
                lightbeam.setColorOverlay(this.attuneCst.getConstellationColor());
            }
        }
        xSh = partDone < 0.5f ? partDone / 0.5f : 1.0f;
        zSh = partDone >= 0.5f ? 1.0f - (partDone - 0.5f) / 0.5f : 1.0f;
        offset = new Vector3(altar).add(4.0, 0.1, 4.0);
        offset.add(-xSh * 7.0f, 0.0, -zSh * 7.0f);
        particle = this.playParticle(offset, rand);
        particle.scale(0.2f + rand.nextFloat() * 0.5f);
        particle.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        particle.motion(rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.01f, rand.nextFloat() * 0.008f * (float)(rand.nextBoolean() ? 1 : -1));
        if (rand.nextInt(12) == 0) {
            lightbeam = EffectHandler.getInstance().lightbeam(offset.clone().addY(3 + rand.nextInt(2)), offset, 1.0);
            lightbeam.setMaxAge(48);
            if (rand.nextInt(4) == 0) {
                lightbeam.setColorOverlay(Color.WHITE);
            } else if (rand.nextInt(3) == 0) {
                lightbeam.setColorOverlay(this.attuneCst.getConstellationColor().brighter());
            } else {
                lightbeam.setColorOverlay(this.attuneCst.getConstellationColor());
            }
        }
        particle = this.playParticle(new Vector3(altar).add(-3.0f + rand.nextFloat() * 7.0f, 0.0, -3.0f + rand.nextFloat() * 7.0f), rand);
        particle.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.1f);
        particle.setColor(this.attuneCst.getConstellationColor().brighter());
    }

    @SideOnly(value=Side.CLIENT)
    private EntityFXFacingParticle playParticle(Vector3 at, Random rand) {
        EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(at);
        particle.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).scale(rand.nextFloat() * 0.4f + 0.27f);
        particle.setMaxAge(50);
        particle.scale(0.2f + rand.nextFloat());
        if (rand.nextInt(4) == 0) {
            particle.setColor(Color.WHITE);
        } else if (rand.nextInt(3) == 0) {
            particle.setColor(this.attuneCst.getConstellationColor().brighter());
        } else {
            particle.setColor(this.attuneCst.getConstellationColor());
        }
        return particle;
    }
}

