/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump.proxy;

import genandnic.walljump.WallJumpConfig;
import genandnic.walljump.client.FallingSound;
import genandnic.walljump.client.PlayerDoubleJump;
import genandnic.walljump.client.PlayerSpeedBoost;
import genandnic.walljump.client.PlayerWallJump;
import genandnic.walljump.packet.PacketForceConfig;
import genandnic.walljump.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientProxy
extends CommonProxy {
    public static final KeyBinding KEY_WALLJUMP = new KeyBinding("walljump.key.walljump", 42, "key.categories.movement");
    private static Minecraft minecraft = Minecraft.func_71410_x();
    private static FallingSound fallingSound = new FallingSound(ClientProxy.minecraft.field_71439_g);
    public static double minFallDistance = WallJumpConfig.minFallDistance;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_WALLJUMP);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP pl = ClientProxy.minecraft.field_71439_g;
        if (event.phase != TickEvent.Phase.END || pl == null) {
            return;
        }
        PlayerWallJump.tryWallJump(pl);
        PlayerDoubleJump.tryDoubleJump(pl);
        PlayerSpeedBoost.trySpeedBoost(pl);
        if (pl.field_70123_F && WallJumpConfig.stepAssist && Math.abs(pl.field_70181_x) < 0.05 && !ClientProxy.collidesWithBlock(pl.field_70170_p, pl.func_174813_aQ().func_72314_b(0.001, (double)(-pl.field_70138_W), 0.001))) {
            pl.field_70122_E = true;
        }
        if (pl.field_71157_e > 0) {
            Vec3d vec3d = new Vec3d(pl.field_70159_w, pl.field_70181_x, pl.field_70179_y);
            if (vec3d.func_72433_c() > 0.08) {
                pl.field_70123_F = false;
            }
        }
        if (pl.field_70143_R > 2.0f && !pl.func_184613_cA()) {
            if (minFallDistance > (double)pl.field_70170_p.func_72800_K()) {
                pl.field_70143_R = 0.0f;
                pl.field_71174_a.func_147297_a((Packet)new CPacketPlayer(true));
            }
            if (WallJumpConfig.playFallSound && fallingSound.func_147667_k()) {
                fallingSound = new FallingSound(ClientProxy.minecraft.field_71439_g);
                minecraft.func_147118_V().func_147682_a((ISound)fallingSound);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(EntityJoinWorldEvent event) {
        if (event.getEntity() == ClientProxy.minecraft.field_71439_g) {
            fallingSound = new FallingSound(ClientProxy.minecraft.field_71439_g);
            minecraft.func_147118_V().func_147682_a((ISound)fallingSound);
        }
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        WallJumpConfig.loadLocalConfig();
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("walljump")) {
            ConfigManager.sync((String)"walljump", (Config.Type)Config.Type.INSTANCE);
            if (!WallJumpConfig.isRemote) {
                WallJumpConfig.loadLocalConfig();
            }
            if (minecraft.func_71387_A()) {
                CommonProxy.NETWORK.sendToAll((IMessage)new PacketForceConfig());
            }
        }
    }

    public static boolean collidesWithBlock(World world, AxisAlignedBB box) {
        return world.func_184143_b(box);
    }
}

