/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.tile.TileEntityBase;
import com.blakebr0.extendedcrafting.block.BlockEnderAlternator;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.EnderCrafterRecipeManager;
import com.blakebr0.extendedcrafting.crafting.endercrafter.IEnderCraftingRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.lib.EmptyContainer;
import com.blakebr0.extendedcrafting.lib.IExtendedTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileEnderCrafter
extends TileEntityBase
implements IInventory,
ITickable,
IExtendedTable {
    private NonNullList<ItemStack> matrix = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private ItemStack result = ItemStack.field_190927_a;
    private int progress;
    private int progressReq;

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            TableCrafting crafting = new TableCrafting(new EmptyContainer(), this);
            IEnderCraftingRecipe recipe = EnderCrafterRecipeManager.getInstance().findMatchingRecipe(crafting, this.func_145831_w());
            ItemStack result = recipe == null ? ItemStack.field_190927_a : ((IRecipe)recipe).func_77572_b((InventoryCrafting)crafting);
            ItemStack output = this.getResult();
            if (!result.func_190926_b() && (output.func_190926_b() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)result))) {
                List<BlockPos> alternators = this.getAlternatorPositions();
                int alternatorCount = alternators.size();
                if (alternatorCount > 0) {
                    this.progress(alternatorCount, recipe.getEnderCrafterTimeSeconds());
                    for (BlockPos pos : alternators) {
                        if (!this.func_145831_w().func_175623_d(pos.func_177984_a())) continue;
                        ((WorldServer)this.func_145831_w()).func_180505_a(EnumParticleTypes.PORTAL, false, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.1, new int[0]);
                    }
                    if (this.progress >= this.progressReq) {
                        for (int i = 0; i < this.matrix.size(); ++i) {
                            this.func_70298_a(i, 1);
                        }
                        this.updateResult(result);
                        this.progress = 0;
                    }
                    this.func_70296_d();
                }
            } else if (this.progress > 0 || this.progressReq > 0) {
                this.progress = 0;
                this.progressReq = 0;
                this.func_70296_d();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_179237_a(ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.matrix));
        if (!this.result.func_190926_b()) {
            tag.func_74782_a("Result", (NBTBase)this.result.serializeNBT());
        } else {
            tag.func_82580_o("Result");
        }
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("ProgressReq", this.progressReq);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.matrix);
        this.result = new ItemStack(tag.func_74775_l("Result"));
        this.progress = tag.func_74762_e("Progress");
        this.progressReq = tag.func_74762_e("ProgressReq");
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public NonNullList<ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public void setResult(ItemStack result) {
        this.result = result;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.matrix.set(slot, (Object)stack);
    }

    @Override
    public int getLineSize() {
        return 3;
    }

    public void updateResult(ItemStack result) {
        if (this.result.func_190926_b()) {
            this.setResult(result);
        } else {
            this.result.func_190917_f(result.func_190916_E());
        }
    }

    public List<BlockPos> getAlternatorPositions() {
        ArrayList<BlockPos> alternators = new ArrayList<BlockPos>();
        this.func_174877_v();
        Iterable blocks = BlockPos.func_177980_a((BlockPos)this.func_174877_v().func_177982_a(-3, -3, -3), (BlockPos)this.func_174877_v().func_177982_a(3, 3, 3));
        for (BlockPos aoePos : blocks) {
            Block block = this.func_145831_w().func_180495_p(aoePos).func_177230_c();
            if (!(block instanceof BlockEnderAlternator)) continue;
            alternators.add(aoePos);
        }
        return alternators;
    }

    public int getProgress() {
        return this.progress;
    }

    private void progress(int alternators, int timeRequired) {
        ++this.progress;
        int timeReq = 20 * timeRequired;
        this.progressReq = (int)Math.max((float)timeReq - (float)timeReq * (ModConfig.confEnderAlternatorEff * (float)alternators), 20.0f);
    }

    public int getProgressRequired() {
        return this.progressReq;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        return this.matrix.isEmpty() && this.result.func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.matrix.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.matrix, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.matrix, (int)index);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.matrix = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        this.setResult(ItemStack.field_190927_a);
    }
}

