/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.endercrafter;

import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.IEnderCraftingRecipe;
import com.blakebr0.extendedcrafting.crafting.table.ITieredRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShapeless;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class EnderCrafterRecipeManager {
    private static final EnderCrafterRecipeManager INSTANCE = new EnderCrafterRecipeManager();
    private List recipes = new ArrayList();

    public static final EnderCrafterRecipeManager getInstance() {
        return INSTANCE;
    }

    public TableRecipeShaped addShaped(ItemStack result, int time, Object ... recipe) {
        TableRecipeShaped craft = new TableRecipeShaped(1, result, recipe);
        if (ModConfig.confEnderEnabled) {
            craft.enderCrafterRecipeTimeRequired = time;
            this.recipes.add(craft);
        }
        return craft;
    }

    public TableRecipeShapeless addShapeless(ItemStack result, int time, Object ... ingredients) {
        TableRecipeShapeless recipe = new TableRecipeShapeless(1, result, ingredients);
        if (ModConfig.confEnderEnabled) {
            recipe.enderCrafterRecipeTimeRequired = time;
            this.recipes.add(recipe);
        }
        return recipe;
    }

    public IEnderCraftingRecipe findMatchingRecipe(TableCrafting grid, World world) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            IRecipe recipe = (IRecipe)this.recipes.get(i);
            if (!recipe.func_77569_a((InventoryCrafting)grid, world)) continue;
            return (IEnderCraftingRecipe)recipe;
        }
        return null;
    }

    public List getRecipes() {
        return this.recipes;
    }

    public void removeRecipes(ItemStack stack) {
        this.recipes.removeIf(o -> o instanceof IRecipe && ((IRecipe)o).func_77571_b().func_77969_a(stack));
    }

    public List getRecipes(int size) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (Object o : this.getRecipes()) {
            IRecipe recipe = (IRecipe)o;
            if (!recipe.func_194133_a(size, size)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public List getRecipesTiered(int tier) {
        ArrayList<ITieredRecipe> recipes = new ArrayList<ITieredRecipe>();
        for (Object o : this.getRecipes()) {
            ITieredRecipe recipe;
            if (!(o instanceof ITieredRecipe) || (recipe = (ITieredRecipe)o).getTier() != tier) continue;
            recipes.add(recipe);
        }
        return recipes;
    }
}

