/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.multiblockstages;

import com.google.common.base.Strings;
import com.teamacronymcoders.multiblockstages.MultiBlockStage;
import crafttweaker.IAction;

public abstract class ActionAddMultiBlockStage
implements IAction {
    private final String gameStage;
    private final String multiBlockName;
    private final String failureMessage;

    public ActionAddMultiBlockStage(String gameStage, String multiBlockName) {
        this(gameStage, multiBlockName, "You cannot form this MultiBlock! Further Progression is Required.");
    }

    public ActionAddMultiBlockStage(String gameStage, String multiBlockName, String failureMessage) {
        this.gameStage = gameStage;
        this.multiBlockName = multiBlockName;
        this.failureMessage = failureMessage;
    }

    public void apply() {
        if (Strings.isNullOrEmpty((String)this.getGameStage())) {
            throw new IllegalArgumentException("Stage cannot be Empty");
        }
        if (Strings.isNullOrEmpty((String)this.getMultiBlockName())) {
            throw new IllegalArgumentException("MultiBlock Name cannot be Empty");
        }
        if (Strings.isNullOrEmpty((String)this.getFailureMessage())) {
            throw new IllegalArgumentException("Failure Message cannot be Empty");
        }
        this.addToHandler(new MultiBlockStage(this.getGameStage(), this.getMultiBlockName(), this.getFailureMessage()));
    }

    public abstract void addToHandler(MultiBlockStage var1);

    public String describe() {
        return "Added MultiBlock " + this.getMultiBlockName() + " to Stage " + this.getGameStage();
    }

    public String getGameStage() {
        return this.gameStage;
    }

    public String getMultiBlockName() {
        return this.multiBlockName;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }
}

