/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.packeditor;

import java.util.ArrayList;
import java.util.List;
import net.gobbob.mobends.client.gui.GuiHelper;
import net.gobbob.mobends.client.gui.packeditor.GuiAddPackButton;
import net.gobbob.mobends.client.gui.packeditor.GuiPackEditor;
import net.gobbob.mobends.client.gui.packeditor.GuiPackEntry;
import net.gobbob.mobends.client.gui.packeditor.GuiPackTab;
import net.gobbob.mobends.pack.BendsPack;
import net.gobbob.mobends.pack.PackManager;
import net.gobbob.mobends.util.Draw;
import net.gobbob.mobends.util.GUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPackList {
    public static final int OFFSET_X = 5;
    public static final int OFFSET_Y = 5;
    public static final int WIDTH = 102;
    public static final int HEIGHT = 153;
    public static final int TAB_PUBLIC = 0;
    public static final int TAB_LOCAL = 1;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int tabId;
    protected int scrollAmount;
    protected int maxScrollAmount;
    protected boolean hovered = false;
    protected GuiPackEditor packEditor;
    protected List<GuiPackTab> tabs;
    protected GuiPackEntry selectedEntry;
    protected GuiAddPackButton addPackButton;

    public GuiPackList(GuiPackEditor packEditor) {
        this.packEditor = packEditor;
        this.y = 0;
        this.x = 0;
        this.maxScrollAmount = 0;
        this.scrollAmount = 0;
        this.width = 104;
        this.height = 155;
        this.tabs = new ArrayList<GuiPackTab>();
        this.tabs.add(new GuiPackTab(0, "mobends.gui.publicpacks"));
        this.tabs.add(new GuiPackTab(1, "mobends.gui.localpacks"));
        this.selectedEntry = null;
        this.addPackButton = new GuiAddPackButton();
        this.selectTab(0, false);
    }

    public void initGui(int x, int y) {
        this.x = x;
        this.y = y;
        this.updatePositions();
    }

    public void updatePositions() {
        for (GuiPackTab tab : this.tabs) {
            tab.initGui(this.x, this.y + 5 + 1);
        }
        this.addPackButton.initGui(this.x + 5, this.y + 5 + this.getSelectedTab().getEntries().size() * 33);
        this.maxScrollAmount = this.getSelectedTab().getEntries().size() * 33 + 20 - 153;
        this.scroll(0.0);
    }

    public void update(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.x + 4 && mouseX <= this.x + 102 - 8 && mouseY >= this.y + 4 && mouseY <= this.y + 153 + 2;
    }

    public void display(int mouseX, int mouseY) {
        this.update(mouseX, mouseY);
        for (GuiPackTab tab : this.tabs) {
            tab.display(mouseX, mouseY, tab.index == this.tabId);
        }
        this.getSelectedTab().display(mouseX, mouseY, true);
        Draw.borderBox(this.x + 4, this.y + 4, 102, 153, 4, 36, 117);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getSelectedTab().getTitle(), (Object[])new Object[0]), (float)(this.x + 40), (float)(this.y - 11), 0xFFFFFF);
        int[] position = GuiHelper.getDeScaledCoords(this.x + 4, this.y + 4 + 153);
        int[] size = GuiHelper.getDeScaledVector(106, 153);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-this.scrollAmount), (float)0.0f);
        int offsetY = this.y;
        for (GuiPackEntry entry : this.getSelectedTab().getEntries()) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)position[0], (int)position[1], (int)size[0], (int)size[1]);
            offsetY += entry.display(mouseX, mouseY + this.scrollAmount);
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)position[0], (int)position[1], (int)size[0], (int)size[1]);
        this.addPackButton.display(mouseX, mouseY + this.scrollAmount);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        for (GuiPackTab tab : this.tabs) {
            if (!tab.mouseClicked(mouseX, mouseY, button)) continue;
            this.selectTab(tab.index, true);
        }
        if (this.hovered && button == 0) {
            for (GuiPackEntry entry : this.getSelectedTab().getEntries()) {
                if (!entry.mouseClicked(mouseX, mouseY + this.scrollAmount, button)) continue;
                this.select(entry, true);
            }
            if (this.addPackButton.mouseClicked(mouseX, mouseY + this.scrollAmount, button)) {
                this.getSelectedTab().addEntry(new GuiPackEntry(this));
                this.updatePositions();
            }
        }
    }

    public void select(GuiPackEntry selected, boolean update) {
        for (GuiPackTab tab : this.tabs) {
            for (GuiPackEntry entry : tab.getEntries()) {
                entry.selected = false;
            }
        }
        this.selectedEntry = selected;
        this.packEditor.onEntrySelected(this.selectedEntry, update);
        if (this.selectedEntry != null) {
            this.selectedEntry.selected = true;
        }
    }

    public void selectTab(int index, boolean update) {
        this.tabId = index;
        if (update) {
            this.updatePositions();
        }
        this.select(null, update);
        switch (this.tabId) {
            case 0: {
                this.addPackButton.setEnabled(false);
                break;
            }
            case 1: {
                this.addPackButton.setEnabled(true);
            }
        }
    }

    public GuiPackTab getTab(int id) {
        return this.tabs.get(id);
    }

    public GuiPackTab getSelectedTab() {
        int tabAmount = Math.max(0, this.tabs.size() - 1);
        this.tabId = GUtil.clampi(this.tabId, 0, tabAmount);
        return this.tabs.get(this.tabId);
    }

    public void populate() {
        for (BendsPack pack : PackManager.getPublicPacks()) {
            this.getTab(0).addEntry(new GuiPackEntry(this, pack));
        }
        for (BendsPack pack : PackManager.getLocalPacks()) {
            this.getTab(1).addEntry(new GuiPackEntry(this, pack));
        }
    }

    public GuiPackEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public void usePack(GuiPackEntry entry) {
        for (GuiPackTab tab : this.tabs) {
            for (GuiPackEntry e : tab.entries) {
                e.setApplied(false);
            }
        }
        entry.setApplied(true);
    }

    public void handleMouseInput() {
        int i2;
        if (this.hovered && (i2 = Mouse.getEventDWheel()) != 0) {
            if (i2 > 0) {
                i2 = -1;
            } else if (i2 < 0) {
                i2 = 1;
            }
            this.scroll(i2 * 15);
        }
        if (Mouse.isButtonDown((int)1) || Mouse.isButtonDown((int)2)) {
            this.scroll(Mouse.getDY());
        }
    }

    public void scroll(double amount) {
        int maxValue = Math.max(0, this.maxScrollAmount);
        this.scrollAmount = GUtil.clampi(this.scrollAmount + (int)amount, 0, maxValue);
    }

    public void apply() {
        PackManager.choose(null);
        for (GuiPackEntry entry : this.tabs.get(1).getEntries()) {
            entry.name = BendsPack.constructName(entry.displayName) + ".bends";
            if (PackManager.getLocal(entry.originalName) == null) {
                PackManager.addLocal(new BendsPack(entry.originalName, entry.displayName, entry.author, entry.description));
            }
            BendsPack pack = PackManager.getLocal(entry.originalName);
            pack.setDisplayName(entry.displayName);
            pack.setAuthor(entry.author);
            pack.setDescription(entry.description);
            if (!entry.originalName.equalsIgnoreCase(entry.name)) {
                PackManager.renamePack(entry.originalName, entry.name);
            }
            if (entry.isApplied()) {
                PackManager.choose(pack);
            }
            pack.saveBasicInfo();
        }
        for (GuiPackEntry entry : this.tabs.get(0).getEntries()) {
            if (!entry.isApplied()) continue;
            PackManager.choose(PackManager.getPublic(entry.name));
            break;
        }
    }
}

