/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.proxy;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.poopycoders.improvedbackpacks.client.LayerBackpack;
import ru.poopycoders.improvedbackpacks.gui.GuiBackpackRename;
import ru.poopycoders.improvedbackpacks.init.ModBlocks;
import ru.poopycoders.improvedbackpacks.init.ModConfig;
import ru.poopycoders.improvedbackpacks.init.ModItems;
import ru.poopycoders.improvedbackpacks.init.ModKeyBindings;
import ru.poopycoders.improvedbackpacks.init.ModTileEntities;
import ru.poopycoders.improvedbackpacks.proxy.CommonProxy;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static IBakedModel BACKPACK_MODEL;
    public static IBakedModel ENDER_BACKPACK_MODEL;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModItems.registerRenders();
        ModBlocks.registerRenders();
        ModTileEntities.registerRenderers();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ModKeyBindings.init();
        ModItems.registerItemColors();
        ModBlocks.registerBlockColors();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        if (ModConfig.renderWearingBackpacks) {
            RenderPlayer def = (RenderPlayer)rm.getSkinMap().get("default");
            def.func_177094_a((LayerRenderer)new LayerBackpack(def));
            RenderPlayer slim = (RenderPlayer)rm.getSkinMap().get("slim");
            slim.func_177094_a((LayerRenderer)new LayerBackpack(slim));
        }
    }

    @Override
    public void openBackpackRenameGui(EntityPlayer player, ItemStack backpack) {
        if (Minecraft.func_71410_x().field_71439_g == player) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBackpackRename(backpack));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        BACKPACK_MODEL = ClientProxy.bakeModel("improvedbackpacks:block/backpack");
        ENDER_BACKPACK_MODEL = ClientProxy.bakeModel("improvedbackpacks:block/ender_backpack");
    }

    private static IBakedModel bakeModel(String location) {
        IModel model = ClientProxy.getModel(new ResourceLocation(location));
        return model.bake(model.getDefaultState(), DefaultVertexFormats.field_176600_a, loc -> Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString()));
    }

    private static IModel getModel(ResourceLocation location) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)location);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

