/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontMeasure;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.util.Logger;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import net.minecraft.util.math.MathHelper;

public class FontProperty {
    public Font font;
    public float size;
    public boolean available;
    public FontMeasure fm;
    public float baseline;
    public float stdBaseline;
    private int style;
    private int fontRes;
    private double scalingFactor;
    private boolean antiAlias;
    private boolean fractionalMetrics;
    private double widthFactor;
    private float pointSize;
    public float ascentGap;

    public FontProperty(String fontName, int fontStyle, int fontRes, double scalingFactor, boolean antiAlias, boolean fractionalMetrics, double widthFactor) {
        this.fontRes = fontRes;
        this.style = fontStyle;
        this.scalingFactor = scalingFactor;
        this.antiAlias = antiAlias;
        this.fractionalMetrics = fractionalMetrics;
        this.widthFactor = widthFactor;
        this.font = new Font(fontName, fontStyle, fontRes);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(this.widthFactor, 1.0);
        this.font = this.font.deriveFont(affineTransform);
        this.pointSize = CommonConfig.currentConfig.fontAutoSizing ? this.getMaxSizePoint(this.font) : (float)fontRes;
        this.font = this.font.deriveFont(this.pointSize);
        this.fm = new FontMeasure(this.font, antiAlias, fractionalMetrics);
        this.stdBaseline = this.fm.getAscentProxy() + this.fm.getLeadingProxy();
        this.pointSize = (float)((double)this.pointSize * scalingFactor);
        this.font = this.font.deriveFont(this.pointSize);
        this.fm = new FontMeasure(this.font, antiAlias, fractionalMetrics);
        this.baseline = this.fm.getAscentProxy() + this.fm.getLeadingProxy();
        this.baseline = MathHelper.func_76123_f((float)this.baseline);
        this.available = FontUtils.isFontAvailable(this.font);
    }

    private float getMaxSizePoint(Font font) {
        FontMeasure fm = new FontMeasure(font, this.antiAlias, this.fractionalMetrics);
        float point = fm.getFittedSize(this.fontRes, 0.0f, 1.0f);
        if (point > 0.0f) {
            point = fm.getFittedSize(this.fontRes, point, 0.1f);
        }
        Logger.info("Suitable font size is " + point + " (" + font.getFontName() + ")");
        return point;
    }
}

