/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.proxy;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockElevator;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderChair;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEnderArrow;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEndermanFighter;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEntityEnderPearl;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderFallingBlockEU;
import fi.dy.masa.enderutilities.client.renderer.model.ItemMeshDefinitionWrapper;
import fi.dy.masa.enderutilities.client.renderer.model.ModelEnderBucket;
import fi.dy.masa.enderutilities.client.renderer.model.ModelEnderTools;
import fi.dy.masa.enderutilities.client.renderer.model.ModelNullifierBaked;
import fi.dy.masa.enderutilities.client.renderer.model.block.BakedModelBarrel;
import fi.dy.masa.enderutilities.client.renderer.model.block.BakedModelInserter;
import fi.dy.masa.enderutilities.client.renderer.model.block.ModelCamouflageBlock;
import fi.dy.masa.enderutilities.client.renderer.tileentity.TESRBarrel;
import fi.dy.masa.enderutilities.client.renderer.tileentity.TileEntityRendererEnergyBridge;
import fi.dy.masa.enderutilities.config.ConfigReader;
import fi.dy.masa.enderutilities.entity.EntityChair;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.entity.EntityEnderPearlReusable;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.entity.EntityFallingBlockEU;
import fi.dy.masa.enderutilities.event.GuiEventHandler;
import fi.dy.masa.enderutilities.event.InputEventHandler;
import fi.dy.masa.enderutilities.event.RenderEventHandler;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.proxy.CommonProxy;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.registry.Keybindings;
import fi.dy.masa.enderutilities.tileentity.TileEntityBarrel;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortal;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortalPanel;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private ModFixs dataFixer = null;

    @Override
    public String format(String key, Object ... args) {
        return I18n.func_135052_a((String)key, (Object[])args);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public EntityPlayer getPlayerFromMessageContext(MessageContext ctx) {
        switch (ctx.side) {
            case CLIENT: {
                return FMLClientHandler.instance().getClientPlayerEntity();
            }
            case SERVER: {
                return ctx.getServerHandler().field_147369_b;
            }
        }
        EnderUtilities.logger.warn("Invalid side in getPlayerFromMessageContext(): " + ctx.side);
        return null;
    }

    @Override
    public ModFixs getDataFixer() {
        if (this.dataFixer == null) {
            this.dataFixer = FMLCommonHandler.instance().getDataFixer().init("enderutilities", 922);
        }
        return this.dataFixer;
    }

    @Override
    public void playSound(int soundId, float pitch, float volume, boolean repeat, boolean stop, float x, float y, float z) {
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(soundId);
        if (sound != null) {
            if (stop) {
                soundHandler.func_189520_a(sound.getRegistryName().toString(), null);
            } else {
                PositionedSoundRecord positionedSound = new PositionedSoundRecord(sound.func_187503_a(), SoundCategory.RECORDS, volume, pitch, repeat, 0, ISound.AttenuationType.LINEAR, x, y, z);
                soundHandler.func_147682_a((ISound)positionedSound);
            }
        }
    }

    @SubscribeEvent
    public void registerBlockColorHandlers(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        if (EnderUtilitiesBlocks.ELEVATOR.isEnabled()) {
            colors.func_186722_a((IBlockColor)new BlockColorHandlerDyes(1, 0xFFFFFF, BlockElevator.COLOR), new Block[]{EnderUtilitiesBlocks.ELEVATOR});
        }
        if (EnderUtilitiesBlocks.ELEVATOR_SLAB.isEnabled()) {
            colors.func_186722_a((IBlockColor)new BlockColorHandlerDyes(1, 0xFFFFFF, BlockElevator.COLOR), new Block[]{EnderUtilitiesBlocks.ELEVATOR_SLAB});
        }
        if (EnderUtilitiesBlocks.ELEVATOR_LAYER.isEnabled()) {
            colors.func_186722_a((IBlockColor)new BlockColorHandlerDyes(1, 0xFFFFFF, BlockElevator.COLOR), new Block[]{EnderUtilitiesBlocks.ELEVATOR_LAYER});
        }
        if (EnderUtilitiesBlocks.PORTAL.isEnabled()) {
            colors.func_186722_a(new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    TileEntityPortal te;
                    if (tintIndex == 1 && pos != null && (te = BlockEnderUtilities.getTileEntitySafely(worldIn, pos, TileEntityPortal.class)) != null) {
                        return te.getColor();
                    }
                    return 10490096;
                }
            }, new Block[]{EnderUtilitiesBlocks.PORTAL});
        }
        if (EnderUtilitiesBlocks.PORTAL_PANEL.isEnabled()) {
            colors.func_186722_a(new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    TileEntityPortalPanel te;
                    if (tintIndex >= 0 && tintIndex <= 8 && pos != null && (te = BlockEnderUtilities.getTileEntitySafely(worldIn, pos, TileEntityPortalPanel.class)) != null) {
                        return te.getColor(tintIndex);
                    }
                    return 0xFFFFFF;
                }
            }, new Block[]{EnderUtilitiesBlocks.PORTAL_PANEL});
        }
    }

    @SubscribeEvent
    public void registerItemColorHandlers(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        if (EnderUtilitiesBlocks.ELEVATOR.isEnabled()) {
            colors.func_186730_a((IItemColor)new ItemColorHandlerDyes(1, 0xFFFFFF), new Item[]{Item.func_150898_a((Block)EnderUtilitiesBlocks.ELEVATOR)});
        }
        if (EnderUtilitiesBlocks.ELEVATOR_SLAB.isEnabled()) {
            colors.func_186730_a((IItemColor)new ItemColorHandlerDyes(1, 0xFFFFFF), new Item[]{Item.func_150898_a((Block)EnderUtilitiesBlocks.ELEVATOR_SLAB)});
        }
        if (EnderUtilitiesBlocks.ELEVATOR_LAYER.isEnabled()) {
            colors.func_186730_a((IItemColor)new ItemColorHandlerDyes(1, 0xFFFFFF), new Item[]{Item.func_150898_a((Block)EnderUtilitiesBlocks.ELEVATOR_LAYER)});
        }
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new ConfigReader());
        MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new InputEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
    }

    @Override
    public void registerKeyBindings() {
        Keybindings.keyActivateUnselected = new KeyBinding("enderutilities.key.activate_unselected", 34, "category.enderutilities");
        Keybindings.keyToggleMode = new KeyBinding("enderutilities.key.togglemode", 34, "category.enderutilities");
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.keyActivateUnselected);
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.keyToggleMode);
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderArrow.class, manager -> new RenderEnderArrow(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderPearlReusable.class, manager -> new RenderEntityEnderPearl(manager, EnderUtilitiesItems.ENDER_PEARL_REUSABLE));
        RenderingRegistry.registerEntityRenderingHandler(EntityEndermanFighter.class, manager -> new RenderEndermanFighter(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityChair.class, manager -> new RenderChair(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingBlockEU.class, manager -> new RenderFallingBlockEU(manager));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBarrel.class, (TileEntitySpecialRenderer)new TESRBarrel());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnergyBridge.class, (TileEntitySpecialRenderer)new TileEntityRendererEnergyBridge());
    }

    @Override
    public boolean isShiftKeyDown() {
        return GuiScreen.func_146272_n();
    }

    @Override
    public boolean isControlKeyDown() {
        return GuiScreen.func_146271_m();
    }

    @Override
    public boolean isAltKeyDown() {
        return GuiScreen.func_175283_s();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerBlockModels();
        ClientProxy.registerItemBlockModels();
        ClientProxy.registerAllItemModels();
    }

    private static void registerAllItemModels() {
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.ENDER_CAPACITOR);
        ClientProxy.registerItemModelWithVariants(EnderUtilitiesItems.ENDER_PART);
        ClientProxy.registerItemModelWithVariants(EnderUtilitiesItems.LINK_CRYSTAL);
        ClientProxy.registerItemModel(EnderUtilitiesItems.BUILDERS_WAND);
        ClientProxy.registerItemModel(EnderUtilitiesItems.CHAIR_WAND);
        ClientProxy.registerItemModel(EnderUtilitiesItems.DOLLY);
        ClientProxy.registerItemModel(EnderUtilitiesItems.ENDER_ARROW);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.ENDER_BAG);
        ClientProxy.registerItemModel(EnderUtilitiesItems.ENDER_BOW);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.ENDER_BUCKET);
        ClientProxy.registerItemModel(EnderUtilitiesItems.ENDER_LASSO);
        ClientProxy.registerItemModelWithVariants(EnderUtilitiesItems.ENDER_PEARL_REUSABLE);
        ClientProxy.registerItemModelWithVariants(EnderUtilitiesItems.ENDER_PORTER);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.ENDER_SWORD);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.ENDER_TOOL);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.HANDY_BAG);
        ClientProxy.registerItemModelWithVariants(EnderUtilitiesItems.ICE_MELTER);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.INVENTORY_SWAPPER);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.LIVING_MANIPULATOR);
        ClientProxy.registerItemModel(EnderUtilitiesItems.MOB_HARNESS);
        ClientProxy.registerItemModelWithNamePrefix(EnderUtilitiesItems.NULLIFIER, 0, "item_");
        ClientProxy.registerItemModel(EnderUtilitiesItems.PET_CONTRACT);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.PICKUP_MANAGER);
        ClientProxy.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.QUICK_STACKER);
        ClientProxy.registerItemModel(EnderUtilitiesItems.PORTAL_SCALER);
        ClientProxy.registerItemModel(EnderUtilitiesItems.RULER);
        ClientProxy.registerItemModelWithVariants(EnderUtilitiesItems.SYRINGE);
        ClientProxy.registerItemModelWithNameSuffix(EnderUtilitiesItems.VOID_PICKAXE, 0, "_normal");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelEnderBucket.LoaderEnderBucket.instance);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelEnderTools.LoaderEnderTools.instance);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelNullifierBaked.ModelLoaderNullifier());
    }

    private static void registerItemModel(ItemEnderUtilities item) {
        ClientProxy.registerItemModel(item, 0);
    }

    private static void registerItemModel(ItemEnderUtilities item, int meta) {
        if (item.isEnabled()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    private static void registerItemModelWithNameSuffix(ItemEnderUtilities item, int meta, String nameSuffix) {
        if (item.isEnabled()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + nameSuffix, "inventory"));
        }
    }

    private static void registerItemModelWithNamePrefix(ItemEnderUtilities item, int meta, String namePrefix) {
        if (item.isEnabled()) {
            ResourceLocation rl = item.getRegistryName();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(rl.func_110624_b() + ":" + namePrefix + rl.func_110623_a(), "inventory"));
        }
    }

    private static void registerItemModelWithVariants(ItemEnderUtilities item) {
        if (item.isEnabled()) {
            ResourceLocation[] variants = item.getItemVariants();
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), (NonNullList<ItemStack>)items);
            int i = 0;
            for (ItemStack stack : items) {
                ModelResourceLocation mrl = variants[i] instanceof ModelResourceLocation ? (ModelResourceLocation)variants[i] : new ModelResourceLocation(variants[i], "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)stack.func_77973_b(), (int)stack.func_77960_j(), (ModelResourceLocation)mrl);
                ++i;
            }
        }
    }

    private static void registerItemModelWithVariantsAndMeshDefinition(ItemEnderUtilities item) {
        if (item.isEnabled()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])item.getItemVariants());
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)ItemMeshDefinitionWrapper.instance());
        }
    }

    private static void registerBlockModels() {
        ModelLoader.setCustomStateMapper((Block)EnderUtilitiesBlocks.BARREL, (IStateMapper)new BakedModelBarrel.StateMapper());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new BakedModelBarrel.ModelLoaderBarrel());
        ModelLoader.setCustomStateMapper((Block)EnderUtilitiesBlocks.INSERTER, (IStateMapper)new BakedModelInserter.StateMapper());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new BakedModelInserter.ModelLoaderInserter());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelCamouflageBlock.ModelLoaderCamouflageBlocks());
        ModelLoader.setCustomStateMapper((Block)EnderUtilitiesBlocks.ELEVATOR, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockElevator.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)EnderUtilitiesBlocks.ELEVATOR_SLAB, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockElevator.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)EnderUtilitiesBlocks.ELEVATOR_LAYER, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockElevator.COLOR}).func_178441_a());
    }

    private static void registerItemBlockModels() {
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.ASU, 0, "tier=1");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.BARREL, 0, "creative=false");
        for (int i = 0; i < 16; ++i) {
            ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.ELEVATOR, i, "inventory");
            ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.ELEVATOR_SLAB, i, "inventory");
            ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.ELEVATOR_LAYER, i, "inventory");
        }
        ClientProxy.registerAllItemBlockModels(EnderUtilitiesBlocks.ENERGY_BRIDGE, "active=false,facing=north,type=", "");
        ClientProxy.registerAllItemBlockModels(EnderUtilitiesBlocks.MACHINE_1, "facing=north,type=", "");
        ClientProxy.registerAllItemBlockModels(EnderUtilitiesBlocks.STORAGE_0, "facing=north,type=", "");
        ClientProxy.registerAllItemBlockModels(EnderUtilitiesBlocks.MSU, "creative=false,type=", "");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.DRAWBRIDGE, 0, "advanced=false,facing=north");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.DRAWBRIDGE, 1, "advanced=true,facing=north");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.ENDER_FURNACE, 0, "facing=north,mode=off");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.FLOOR, 0, "half=bottom,type=normal");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.FLOOR, 1, "half=bottom,type=cracked");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.INSERTER, 0, "type=normal");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.INSERTER, 1, "type=filtered");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.MOLECULAR_EXCITER, 0, "facing=north,powered=false");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.PHASING, 0, "inverted=false,powered=false");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.PHASING, 1, "inverted=true,powered=true");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.PORTAL_FRAME, 0, "inventory");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.PORTAL_PANEL, 0, "facing=north");
        ClientProxy.registerItemBlockModel(EnderUtilitiesBlocks.SOUND_BLOCK, 0, "inventory");
    }

    private static void registerItemBlockModel(BlockEnderUtilities blockIn, int meta, String fullVariant) {
        if (blockIn.isEnabled()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)blockIn), (int)meta, (ModelResourceLocation)new ModelResourceLocation(blockIn.getRegistryName(), fullVariant));
        }
    }

    private static void registerAllItemBlockModels(BlockEnderUtilities blockIn, String variantPre, String variantPost) {
        if (blockIn.isEnabled()) {
            NonNullList stacks = NonNullList.func_191196_a();
            blockIn.func_149666_a(blockIn.func_149708_J(), stacks);
            String[] names = blockIn.getUnlocalizedNames();
            for (ItemStack stack : stacks) {
                Item item = stack.func_77973_b();
                int meta = stack.func_77960_j();
                ModelResourceLocation mrl = new ModelResourceLocation(item.getRegistryName(), variantPre + names[meta] + variantPost);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)mrl);
            }
        }
    }

    private static class ItemColorHandlerDyes
    implements IItemColor {
        private final int targetTintIndex;
        private final int defaultColor;

        private ItemColorHandlerDyes(int targetTintIndex, int defaultColor) {
            this.targetTintIndex = targetTintIndex;
            this.defaultColor = defaultColor;
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            return tintIndex == this.targetTintIndex ? MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)stack.func_77960_j())).field_76291_p : this.defaultColor;
        }
    }

    private static class BlockColorHandlerDyes
    implements IBlockColor {
        private final int targetTintIndex;
        private final int defaultColor;
        private final PropertyEnum<EnumDyeColor> prop;

        private BlockColorHandlerDyes(int targetTintIndex, int defaultColor, PropertyEnum<EnumDyeColor> prop) {
            this.targetTintIndex = targetTintIndex;
            this.defaultColor = defaultColor;
            this.prop = prop;
        }

        public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
            return tintIndex == this.targetTintIndex ? MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b(this.prop))).field_76291_p : this.defaultColor;
        }
    }
}

