/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.ai;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AIHelperLiquid {
    public static boolean isInLiquid(Entity entity) {
        return entity.func_70090_H() || entity.func_180799_ab();
    }

    public static boolean isDirectPathBetweenPoints(World world, Vec3d pos1, Vec3d pos2, int entityXSize, int entityYSize, int entityZSize) {
        int l = MathHelper.func_76128_c((double)pos1.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)pos1.field_72449_c);
        double d0 = pos2.field_72450_a - pos1.field_72450_a;
        double d1 = pos2.field_72449_c - pos1.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!AIHelperLiquid.isSafeToSwimAt(world, l, (int)pos1.field_72448_b, i1, entityXSize += 2, entityYSize, entityZSize += 2, pos1, d0 *= d3, d1 *= d3)) {
            return false;
        }
        entityXSize -= 2;
        entityZSize -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)(l * 1) - pos1.field_72450_a;
        double d7 = (double)(i1 * 1) - pos1.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int j1 = d0 < 0.0 ? -1 : 1;
        int k1 = d1 < 0.0 ? -1 : 1;
        int l1 = MathHelper.func_76128_c((double)pos2.field_72450_a);
        int i2 = MathHelper.func_76128_c((double)pos2.field_72449_c);
        int j2 = l1 - l;
        int k2 = i2 - i1;
        do {
            if (j2 * j1 <= 0 && k2 * k1 <= 0) {
                return true;
            }
            if (d6 < d7) {
                d6 += d4;
                j2 = l1 - (l += j1);
                continue;
            }
            d7 += d5;
            k2 = i2 - (i1 += k1);
        } while (AIHelperLiquid.isSafeToSwimAt(world, l, (int)pos1.field_72448_b, i1, entityXSize, entityYSize, entityZSize, pos1, d0, d1));
        return false;
    }

    public static boolean isSafeToSwimAt(World world, int xOffset, int yOffset, int zOffset, int entityXSize, int entityYSize, int entityZSize, Vec3d originPosition, double vecX, double vecZ) {
        int k1 = xOffset - entityXSize / 2;
        int l1 = zOffset - entityZSize / 2;
        if (!AIHelperLiquid.isPositionClear(world, k1, yOffset, l1, entityXSize, entityYSize, entityZSize, originPosition, vecX, vecZ)) {
            return false;
        }
        for (int i2 = k1; i2 < k1 + entityXSize; ++i2) {
            for (int j2 = l1; j2 < l1 + entityZSize; ++j2) {
                Material material;
                double d2 = (double)i2 + 0.5 - originPosition.field_72450_a;
                double d3 = (double)j2 + 0.5 - originPosition.field_72449_c;
                if (!(d2 * vecX + d3 * vecZ >= 0.0) || (material = world.func_180495_p(new BlockPos(i2, yOffset, j2)).func_185904_a()) == Material.field_151586_h || material == Material.field_151587_i) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isPositionClear(World world, int xOffset, int yOffset, int zOffset, int entityXSize, int entityYSize, int entityZSize, Vec3d originPosition, double vecX, double vecZ) {
        for (int k1 = xOffset; k1 < xOffset + entityXSize; ++k1) {
            for (int l1 = yOffset; l1 < yOffset + entityYSize; ++l1) {
                for (int i2 = zOffset; i2 < zOffset + entityZSize; ++i2) {
                    BlockPos pos;
                    Block block;
                    double d2 = (double)k1 + 0.5 - originPosition.field_72450_a;
                    double d3 = (double)i2 + 0.5 - originPosition.field_72449_c;
                    if (!(d2 * vecX + d3 * vecZ >= 0.0) || (block = world.func_180495_p(pos = new BlockPos(k1, l1, i2)).func_177230_c()).func_176205_b((IBlockAccess)world, pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

