/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever;

import com.buuz135.togetherforever.api.IOfflineSyncRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ISyncAction;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.TogetherForeverAPI;
import com.buuz135.togetherforever.api.annotation.PlayerInformation;
import com.buuz135.togetherforever.api.annotation.SyncAction;
import com.buuz135.togetherforever.api.annotation.TogetherTeam;
import com.buuz135.togetherforever.api.command.TogetherForeverCommand;
import com.buuz135.togetherforever.api.data.DataManager;
import com.buuz135.togetherforever.api.data.DefaultPlayerInformation;
import com.buuz135.togetherforever.api.data.TogetherRegistries;
import com.buuz135.togetherforever.command.AcceptInviteCommand;
import com.buuz135.togetherforever.command.DeclineInviteCommand;
import com.buuz135.togetherforever.command.ForceSyncCommand;
import com.buuz135.togetherforever.command.HelpCommand;
import com.buuz135.togetherforever.command.InviteCommand;
import com.buuz135.togetherforever.command.TeamInfoCommand;
import com.buuz135.togetherforever.command.TeamKickCommand;
import com.buuz135.togetherforever.command.TeamLeaveCommand;
import com.buuz135.togetherforever.command.TogetherForeverDebug;
import com.buuz135.togetherforever.config.TogetherForeverConfig;
import com.buuz135.togetherforever.utils.AnnotationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="togetherforever", name="TogetherForever", version="1.0.2", dependencies="required:forge@[14.23.1.2560,);after:gamestages@[2.0.90,);after:reskillable@[1.9.1,);", acceptedMinecraftVersions="[1.12.2]")
public class TogetherForever {
    public static final String MOD_ID = "togetherforever";
    public static final String MOD_NAME = "TogetherForever";
    public static final String VERSION = "1.0.2";
    public static Logger LOGGER;
    @Mod.Instance(value="togetherforever")
    public static TogetherForever INSTANCE;
    public static HashMap<String, Long> joinedPlayers;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        try {
            this.registerSyncActions(event.getAsmData());
            this.registerTogetherTeams(event.getAsmData());
            this.registerPlayerInformations(event.getAsmData());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        TogetherForeverCommand command = new TogetherForeverCommand(Arrays.asList(new HelpCommand(), new InviteCommand(), new AcceptInviteCommand(), new DeclineInviteCommand(), new TeamKickCommand(), new TeamLeaveCommand(), new TeamInfoCommand(), new ForceSyncCommand()));
        event.registerServerCommand((ICommand)command);
        event.registerServerCommand((ICommand)new TogetherForeverDebug());
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP && TogetherForeverAPI.getInstance().getPlayerTeam(event.player.func_110124_au()) != null) {
            joinedPlayers.put(event.player.func_70005_c_(), System.currentTimeMillis());
            if (TogetherForeverConfig.syncDataSecondsDelay > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Syncing team data in " + TogetherForeverConfig.syncDataSecondsDelay + " seconds!"));
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        ArrayList<String> remove = new ArrayList<String>();
        for (String name : joinedPlayers.keySet()) {
            if (System.currentTimeMillis() - joinedPlayers.get(name) < (long)(TogetherForeverConfig.syncDataSecondsDelay * 1000)) continue;
            remove.add(name);
            EntityPlayerMP playerMP = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
            if (playerMP == null) continue;
            playerMP.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Trying to sync team data now!"));
            DefaultPlayerInformation information = DefaultPlayerInformation.createInformation(playerMP);
            DataManager manager = TogetherForeverAPI.getInstance().getDataManager(playerMP.field_70170_p);
            for (IOfflineSyncRecovery recovery : manager.getRecoveries()) {
                recovery.recoverMissingPlayer(information);
            }
            manager.func_76185_a();
        }
        for (String s : remove) {
            joinedPlayers.remove(s);
        }
    }

    private void registerSyncActions(ASMDataTable data) throws IllegalAccessException, InstantiationException {
        for (Class<?> aClass : AnnotationHelper.getAnnotatedClasses(data, SyncAction.class)) {
            SyncAction syncAction;
            if (!ISyncAction.class.isAssignableFrom(aClass) || (syncAction = aClass.getAnnotation(SyncAction.class)).dependencies().length != 0 && !this.areDependenciesLoaded(syncAction.dependencies())) continue;
            Object object = aClass.newInstance();
            TogetherRegistries.registerSyncAction(syncAction.id(), (ISyncAction)object);
        }
    }

    private void registerTogetherTeams(ASMDataTable data) {
        for (Class<?> aClass : AnnotationHelper.getAnnotatedClasses(data, TogetherTeam.class)) {
            if (!ITogetherTeam.class.isAssignableFrom(aClass)) continue;
            TogetherTeam togetherTeam = aClass.getAnnotation(TogetherTeam.class);
            TogetherRegistries.registerTogetherTeam(togetherTeam.id(), aClass);
        }
    }

    private void registerPlayerInformations(ASMDataTable data) {
        for (Class<?> aClass : AnnotationHelper.getAnnotatedClasses(data, PlayerInformation.class)) {
            if (!IPlayerInformation.class.isAssignableFrom(aClass)) continue;
            PlayerInformation playerInformation = aClass.getAnnotation(PlayerInformation.class);
            TogetherRegistries.registerPlayerInformation(playerInformation.id(), aClass);
        }
    }

    private boolean areDependenciesLoaded(String[] deps) {
        for (String dep : deps) {
            if (Loader.isModLoaded((String)dep)) continue;
            return false;
        }
        return true;
    }

    static {
        joinedPlayers = new HashMap();
    }
}

