/*
 * Decompiled with CFR 0.152.
 */
package igwmod.network;

import igwmod.IGWMod;
import igwmod.api.WikiRegistry;
import igwmod.gui.tabs.ServerWikiTab;
import igwmod.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class MessageSendServerTab
extends AbstractPacket<MessageSendServerTab> {
    private File serverFolder;

    public MessageSendServerTab() {
    }

    public MessageSendServerTab(File serverFolder) {
        this.serverFolder = serverFolder;
    }

    public void toBytes(ByteBuf buf) {
        File[] files = this.serverFolder.listFiles();
        buf.writeInt(files.length);
        for (File file : files) {
            try {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)file.getName());
                FileInputStream stream = new FileInputStream(file);
                byte[] byteArray = IOUtils.toByteArray((InputStream)stream);
                buf.writeInt(byteArray.length);
                buf.writeBytes(byteArray);
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        File folder = new File(IGWMod.proxy.getSaveLocation() + File.separator + "igwmod" + File.separator);
        folder.mkdirs();
        try {
            FileUtils.deleteDirectory((File)folder);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        folder.mkdirs();
        int fileAmount = buf.readInt();
        for (int i = 0; i < fileAmount; ++i) {
            try {
                File file = new File(folder.getAbsolutePath() + File.separator + ByteBufUtils.readUTF8String((ByteBuf)buf));
                byte[] fileBytes = new byte[buf.readInt()];
                buf.readBytes(fileBytes);
                FileOutputStream stream = new FileOutputStream(file);
                IOUtils.write((byte[])fileBytes, (OutputStream)stream);
                stream.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void handleClientSide(MessageSendServerTab message, EntityPlayer player) {
        WikiRegistry.registerWikiTab(new ServerWikiTab());
    }

    @Override
    public void handleServerSide(MessageSendServerTab message, EntityPlayer player) {
    }
}

