/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.simplyarrows.logic;

import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.simplyarrows.entity.EntitySimpleArrow;
import net.darkhax.simplyarrows.logic.IArrowLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ArrowLogicPlaceBlock
implements IArrowLogic {
    private final Block block;
    private final int meta;
    private final ItemStack fallbackItem;

    public ArrowLogicPlaceBlock(Block block) {
        this(block, 0);
    }

    public ArrowLogicPlaceBlock(Block block, Block blockItem) {
        this(block, Item.func_150898_a((Block)blockItem));
    }

    public ArrowLogicPlaceBlock(Block block, Item item) {
        this(block, new ItemStack(item));
    }

    public ArrowLogicPlaceBlock(Block block, ItemStack fallback) {
        this(block, 0, fallback);
    }

    public ArrowLogicPlaceBlock(Block block, int meta) {
        this(block, meta, ItemStack.field_190927_a);
    }

    public ArrowLogicPlaceBlock(Block block, int meta, ItemStack fallback) {
        this.block = block;
        this.meta = meta;
        this.fallbackItem = fallback;
    }

    @Override
    public void onBlockHit(EntitySimpleArrow arrow, RayTraceResult hit) {
        BlockPos pos;
        World world = arrow.func_130014_f_();
        if (world.func_180495_p(pos = hit.func_178782_a().func_177972_a(hit.field_178784_b)).func_177230_c().func_176200_f((IBlockAccess)world, pos) && this.block.func_176198_a(world, pos, hit.field_178784_b)) {
            EntityLivingBase shooter = arrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)arrow.field_70250_c : null;
            arrow.func_130014_f_().func_175656_a(pos, this.block.getStateForPlacement(world, pos, hit.field_178784_b, 0.5f, 0.5f, 0.5f, this.meta, shooter, EnumHand.MAIN_HAND));
            arrow.func_70106_y();
        } else if (!this.fallbackItem.func_190926_b()) {
            StackUtils.dropStackInWorld((World)world, (BlockPos)pos, (ItemStack)this.fallbackItem);
            arrow.func_70106_y();
        }
    }

    public ItemStack getFallbackItem() {
        return this.fallbackItem;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }
}

