/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.common.EntityYoyo;
import com.jozufozu.yoyos.common.IBlockInteraction;
import com.jozufozu.yoyos.common.IEntityInteraction;
import com.jozufozu.yoyos.common.IYoyo;
import com.jozufozu.yoyos.common.ModConfig;
import com.jozufozu.yoyos.common.RenderOrientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockReed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemYoyo
extends Item
implements IYoyo {
    private final float attackDamage;
    protected final Item.ToolMaterial material;
    protected BiFunction<World, EntityPlayer, EntityYoyo> yoyoFactory;
    protected RenderOrientation renderOrientation = RenderOrientation.Vertical;
    protected ArrayList<IEntityInteraction> entityInteractions;
    protected ArrayList<IBlockInteraction> blockInteractions;

    public ItemYoyo(String name, Item.ToolMaterial material) {
        this(name, material, EntityYoyo::new);
    }

    public ItemYoyo(String name, Item.ToolMaterial material, BiFunction<World, EntityPlayer, EntityYoyo> yoyoFactory) {
        this(name, material, yoyoFactory, Lists.newArrayList((Object[])new IEntityInteraction[]{ItemYoyo::collectItem, ItemYoyo::attackEntity}), new ArrayList<IBlockInteraction>());
    }

    public ItemYoyo(String name, Item.ToolMaterial material, BiFunction<World, EntityPlayer, EntityYoyo> yoyoFactory, @Nonnull ArrayList<IEntityInteraction> entityInteractions, @Nonnull ArrayList<IBlockInteraction> blockInteractions) {
        this.yoyoFactory = yoyoFactory;
        this.entityInteractions = entityInteractions;
        this.blockInteractions = blockInteractions;
        this.material = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.func_77637_a(Yoyos.YOYOS_TAB);
        this.attackDamage = 3.0f + material.func_78000_c();
        this.func_77655_b(String.format("%s.%s", "yoyos", name));
        this.setRegistryName("yoyos", name);
        this.func_185043_a(new ResourceLocation("yoyos", "thrown"), (stack, worldIn, entityIn) -> entityIn instanceof EntityBat ? 1.0f : 0.0f);
    }

    public ItemYoyo addBlockInteraction(IBlockInteraction ... blockInteraction) {
        Collections.addAll(this.blockInteractions, blockInteraction);
        return this;
    }

    public ItemYoyo addEntityInteraction(IEntityInteraction ... entityInteraction) {
        Collections.addAll(this.entityInteractions, entityInteraction);
        return this;
    }

    public ItemYoyo setRenderOrientation(RenderOrientation renderOrientation) {
        this.renderOrientation = renderOrientation;
        return this;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"yoyo");
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_191530_r) {
            return false;
        }
        if (enchantment == Enchantments.field_185308_t && this.interactsWithBlocks(stack)) {
            return true;
        }
        return enchantment == Yoyos.COLLECTING || enchantment.field_77351_y == EnumEnchantmentType.ALL || enchantment.field_77351_y == EnumEnchantmentType.WEAPON;
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || this == Yoyos.CREATIVE_YOYO;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        return OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false) || super.func_82789_a(toRepair, repair);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            this.damageItem(stack, 2, entityLiving);
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        this.damageItem(stack, 1, attacker);
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (!(worldIn.field_72995_K || EntityYoyo.CASTERS.containsKey(playerIn) || itemStack.func_77952_i() > itemStack.func_77958_k() && this != Yoyos.CREATIVE_YOYO)) {
            EntityYoyo yoyo = this.yoyoFactory.apply(worldIn, playerIn);
            worldIn.func_72838_d((Entity)yoyo);
            worldIn.func_184148_a(null, yoyo.field_70165_t, yoyo.field_70163_u, yoyo.field_70161_v, Yoyos.YOYO_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            playerIn.func_71020_j(0.05f);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"yoyos.info.weight.name", (Object[])new Object[]{Float.valueOf(this.getWeight(stack))}));
        tooltip.add(I18n.func_135052_a((String)"yoyos.info.length.name", (Object[])new Object[]{Float.valueOf(this.getLength(stack))}));
        int duration = this.getDuration(stack);
        Object arg = duration < 0 ? I18n.func_135052_a((String)"stat.yoyo.infinite.name", (Object[])new Object[0]) : Float.valueOf((float)duration / 20.0f);
        tooltip.add(I18n.func_135052_a((String)"yoyos.info.duration.name", (Object[])new Object[]{arg}));
        if (stack.func_77948_v()) {
            tooltip.add("");
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND || equipmentSlot == EntityEquipmentSlot.OFFHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public float getAttackDamage(ItemStack yoyo) {
        if (this == Yoyos.SHEAR_YOYO) {
            return ModConfig.vanillaYoyos.shearYoyo.damage;
        }
        if (this == Yoyos.STICKY_YOYO) {
            return ModConfig.vanillaYoyos.stickyYoyo.damage;
        }
        if (this == Yoyos.HOE_YOYO) {
            return ModConfig.vanillaYoyos.hoeYoyo.damage;
        }
        if (this == Yoyos.DIAMOND_YOYO) {
            return ModConfig.vanillaYoyos.diamondYoyo.damage;
        }
        if (this == Yoyos.GOLD_YOYO) {
            return ModConfig.vanillaYoyos.goldYoyo.damage;
        }
        if (this == Yoyos.IRON_YOYO) {
            return ModConfig.vanillaYoyos.ironYoyo.damage;
        }
        if (this == Yoyos.STONE_YOYO) {
            return ModConfig.vanillaYoyos.stoneYoyo.damage;
        }
        if (this == Yoyos.WOODEN_YOYO) {
            return ModConfig.vanillaYoyos.woodenYoyo.damage;
        }
        if (this == Yoyos.CREATIVE_YOYO) {
            return ModConfig.vanillaYoyos.creativeYoyo.damage;
        }
        return this.attackDamage;
    }

    @Override
    public float getWeight(ItemStack yoyo) {
        if (this == Yoyos.SHEAR_YOYO) {
            return ModConfig.vanillaYoyos.shearYoyo.weight;
        }
        if (this == Yoyos.STICKY_YOYO) {
            return ModConfig.vanillaYoyos.stickyYoyo.weight;
        }
        if (this == Yoyos.HOE_YOYO) {
            return ModConfig.vanillaYoyos.hoeYoyo.weight;
        }
        if (this == Yoyos.DIAMOND_YOYO) {
            return ModConfig.vanillaYoyos.diamondYoyo.weight;
        }
        if (this == Yoyos.GOLD_YOYO) {
            return ModConfig.vanillaYoyos.goldYoyo.weight;
        }
        if (this == Yoyos.IRON_YOYO) {
            return ModConfig.vanillaYoyos.ironYoyo.weight;
        }
        if (this == Yoyos.STONE_YOYO) {
            return ModConfig.vanillaYoyos.stoneYoyo.weight;
        }
        if (this == Yoyos.WOODEN_YOYO) {
            return ModConfig.vanillaYoyos.woodenYoyo.weight;
        }
        if (this == Yoyos.CREATIVE_YOYO) {
            return ModConfig.vanillaYoyos.creativeYoyo.weight;
        }
        return 1.0f;
    }

    @Override
    public float getLength(ItemStack yoyo) {
        if (this == Yoyos.SHEAR_YOYO) {
            return ModConfig.vanillaYoyos.shearYoyo.length;
        }
        if (this == Yoyos.STICKY_YOYO) {
            return ModConfig.vanillaYoyos.stickyYoyo.length;
        }
        if (this == Yoyos.HOE_YOYO) {
            return ModConfig.vanillaYoyos.hoeYoyo.length;
        }
        if (this == Yoyos.DIAMOND_YOYO) {
            return ModConfig.vanillaYoyos.diamondYoyo.length;
        }
        if (this == Yoyos.GOLD_YOYO) {
            return ModConfig.vanillaYoyos.goldYoyo.length;
        }
        if (this == Yoyos.IRON_YOYO) {
            return ModConfig.vanillaYoyos.ironYoyo.length;
        }
        if (this == Yoyos.STONE_YOYO) {
            return ModConfig.vanillaYoyos.stoneYoyo.length;
        }
        if (this == Yoyos.WOODEN_YOYO) {
            return ModConfig.vanillaYoyos.woodenYoyo.length;
        }
        if (this == Yoyos.CREATIVE_YOYO) {
            return ModConfig.vanillaYoyos.creativeYoyo.length;
        }
        return 1.0f;
    }

    @Override
    public int getDuration(ItemStack yoyo) {
        if (this == Yoyos.SHEAR_YOYO) {
            return ModConfig.vanillaYoyos.shearYoyo.duration;
        }
        if (this == Yoyos.STICKY_YOYO) {
            return ModConfig.vanillaYoyos.stickyYoyo.duration;
        }
        if (this == Yoyos.HOE_YOYO) {
            return ModConfig.vanillaYoyos.hoeYoyo.duration;
        }
        if (this == Yoyos.DIAMOND_YOYO) {
            return ModConfig.vanillaYoyos.diamondYoyo.duration;
        }
        if (this == Yoyos.GOLD_YOYO) {
            return ModConfig.vanillaYoyos.goldYoyo.duration;
        }
        if (this == Yoyos.IRON_YOYO) {
            return ModConfig.vanillaYoyos.ironYoyo.duration;
        }
        if (this == Yoyos.STONE_YOYO) {
            return ModConfig.vanillaYoyos.stoneYoyo.duration;
        }
        if (this == Yoyos.WOODEN_YOYO) {
            return ModConfig.vanillaYoyos.woodenYoyo.duration;
        }
        if (this == Yoyos.CREATIVE_YOYO) {
            return ModConfig.vanillaYoyos.creativeYoyo.duration;
        }
        return 10;
    }

    @Override
    public int getAttackInterval(ItemStack yoyo) {
        if (this == Yoyos.CREATIVE_YOYO) {
            return 0;
        }
        return 10;
    }

    @Override
    public int getMaxCollectedDrops(ItemStack yoyo) {
        if (this == Yoyos.CREATIVE_YOYO) {
            return Integer.MAX_VALUE;
        }
        return ItemYoyo.calculateMaxCollectedDrops(EnchantmentHelper.func_77506_a((Enchantment)Yoyos.COLLECTING, (ItemStack)yoyo));
    }

    public static int calculateMaxCollectedDrops(int level) {
        if (level == 0) {
            return 0;
        }
        int mult = 1;
        for (int i = 0; i < level - 1; ++i) {
            mult *= 2;
        }
        return ModConfig.collectingBase * mult;
    }

    @Override
    public void damageItem(ItemStack yoyo, int amount, EntityLivingBase player) {
        yoyo.func_77972_a(amount, player);
    }

    @Override
    public void entityInteraction(ItemStack yoyo, EntityPlayer player, EnumHand hand, EntityYoyo yoyoEntity, Entity targetEntity) {
        if (targetEntity.field_70170_p.field_72995_K) {
            return;
        }
        for (IEntityInteraction entityInteraction : this.entityInteractions) {
            if (!entityInteraction.entityInteraction(yoyo, player, hand, yoyoEntity, targetEntity)) continue;
            return;
        }
    }

    @Override
    public boolean interactsWithBlocks(ItemStack yoyo) {
        return this.blockInteractions != null && !this.blockInteractions.isEmpty();
    }

    @Override
    public void blockInteraction(ItemStack yoyo, EntityPlayer player, World world, BlockPos pos, IBlockState state, Block block, EntityYoyo yoyoEntity) {
        if (world.field_72995_K) {
            return;
        }
        for (IBlockInteraction blockInteraction : this.blockInteractions) {
            if (!blockInteraction.blockInteraction(yoyo, player, pos, state, block, yoyoEntity)) continue;
            return;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderOrientation getRenderOrientation(ItemStack yoyo) {
        return this.renderOrientation;
    }

    public static boolean collectItem(ItemStack yoyo, EntityPlayer player, EnumHand hand, EntityYoyo yoyoEntity, Entity targetEntity) {
        if (targetEntity instanceof EntityItem && yoyoEntity.isCollecting()) {
            yoyoEntity.collectDrop((EntityItem)targetEntity);
            return true;
        }
        return false;
    }

    public static boolean shearEntity(ItemStack yoyo, EntityPlayer player, EnumHand hand, EntityYoyo yoyoEntity, Entity targetEntity) {
        if (targetEntity instanceof IShearable) {
            IShearable shearable = (IShearable)targetEntity;
            World world = targetEntity.field_70170_p;
            BlockPos pos = new BlockPos(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v);
            if (shearable.isShearable(yoyo, (IBlockAccess)world, pos)) {
                yoyoEntity.yoyo.damageItem(yoyo, 1, (EntityLivingBase)player);
                List stacks = shearable.onSheared(yoyo, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)yoyo));
                for (ItemStack stack : stacks) {
                    yoyoEntity.createItemDropOrCollect(stack, pos);
                }
                yoyoEntity.increaseTimeout(10);
            }
            return true;
        }
        return false;
    }

    public static boolean till(ItemStack yoyo, EntityPlayer player, BlockPos pos, IBlockState state, Block block, EntityYoyo yoyoEntity) {
        World worldIn = yoyoEntity.field_70170_p;
        if ((double)pos.func_177956_o() + 0.9 < yoyoEntity.field_70163_u && worldIn.func_175623_d(pos.func_177984_a())) {
            int hook = ForgeEventFactory.onHoeUse((ItemStack)yoyo, (EntityPlayer)player, (World)worldIn, (BlockPos)pos);
            if (hook != 0) {
                return true;
            }
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                ItemYoyo.setBlock(yoyo, player, yoyoEntity, pos, Blocks.field_150458_ak.func_176223_P());
                return true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        ItemYoyo.setBlock(yoyo, player, yoyoEntity, pos, Blocks.field_150458_ak.func_176223_P());
                        return true;
                    }
                    case COARSE_DIRT: {
                        ItemYoyo.setBlock(yoyo, player, yoyoEntity, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void setBlock(ItemStack yoyo, EntityPlayer player, EntityYoyo yoyoEntity, BlockPos pos, IBlockState state) {
        yoyoEntity.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!yoyoEntity.field_70170_p.field_72995_K) {
            yoyoEntity.field_70170_p.func_180501_a(pos, state, 11);
            yoyoEntity.getYoyo().damageItem(yoyo, 1, (EntityLivingBase)player);
        }
    }

    public static boolean garden(ItemStack yoyo, EntityPlayer player, BlockPos pos, IBlockState state, Block block, EntityYoyo yoyoEntity) {
        IShearable shearable;
        World world = yoyoEntity.field_70170_p;
        if (block instanceof IShearable && (shearable = (IShearable)block).isShearable(yoyo, (IBlockAccess)world, pos)) {
            ArrayList stacks = shearable.onSheared(yoyo, (IBlockAccess)world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)yoyo));
            if (!world.func_82736_K().func_82766_b("doTileDrops")) {
                stacks = new ArrayList();
            }
            if (yoyoEntity.field_70170_p.func_175698_g(pos)) {
                block.func_180663_b(world, pos, state);
                yoyoEntity.getYoyo().damageItem(yoyo, 1, (EntityLivingBase)player);
                yoyoEntity.increaseTimeout(10);
                for (ItemStack stack : stacks) {
                    yoyoEntity.createItemDropOrCollect(stack, pos);
                }
                world.func_184133_a(null, pos, block.getSoundType(state, world, pos, (Entity)yoyoEntity).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_175718_b(2001, pos.func_185334_h(), Block.func_176210_f((IBlockState)state));
                return true;
            }
        }
        if (block instanceof BlockBush || block instanceof BlockReed) {
            ItemYoyo.doBlockBreaking(yoyo, player, world, pos, state, block, yoyoEntity);
            return true;
        }
        return false;
    }

    public static boolean farm(ItemStack yoyo, EntityPlayer player, BlockPos pos, IBlockState state, Block block, EntityYoyo yoyoEntity) {
        if (block instanceof BlockCrops && ((BlockCrops)block).func_185525_y(state)) {
            NonNullList<ItemStack> drops = ItemYoyo.doHarvesting(yoyo, player, yoyoEntity.field_70170_p, pos, state, block, yoyoEntity);
            if (drops == null) {
                return true;
            }
            if (!yoyoEntity.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) {
                drops.clear();
            }
            yoyoEntity.getYoyo().damageItem(yoyo, 1, (EntityLivingBase)player);
            boolean foundSeed = false;
            for (ItemStack stack : drops) {
                if (stack.func_190926_b()) continue;
                if (ModConfig.replant && !foundSeed && stack.func_77973_b() instanceof IPlantable) {
                    stack.func_190918_g(1);
                    foundSeed = true;
                }
                yoyoEntity.createItemDropOrCollect(stack, pos);
            }
            if (ModConfig.replant) {
                if (!foundSeed && !yoyoEntity.collectedDrops.isEmpty()) {
                    for (ItemStack stack : yoyoEntity.collectedDrops) {
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
                        stack.func_190918_g(1);
                        yoyoEntity.needCollectedSync = true;
                        foundSeed = true;
                        break;
                    }
                }
                if (foundSeed) {
                    yoyoEntity.field_70170_p.func_175656_a(pos, ((BlockCrops)block).func_185528_e(0));
                }
            }
            return true;
        }
        return false;
    }

    public static void doBlockBreaking(ItemStack yoyo, EntityPlayer player, World world, BlockPos pos, IBlockState state, Block block, EntityYoyo yoyoEntity) {
        NonNullList<ItemStack> itemStacks = ItemYoyo.doHarvesting(yoyo, player, world, pos, state, block, yoyoEntity);
        if (itemStacks == null) {
            return;
        }
        yoyoEntity.getYoyo().damageItem(yoyo, 1, (EntityLivingBase)player);
        if (!world.func_82736_K().func_82766_b("doTileDrops")) {
            return;
        }
        for (ItemStack stack : itemStacks) {
            yoyoEntity.createItemDropOrCollect(stack, pos);
        }
    }

    @Nullable
    private static NonNullList<ItemStack> doHarvesting(ItemStack yoyo, EntityPlayer player, World world, BlockPos pos, IBlockState state, Block block, EntityYoyo yoyoEntity) {
        if (!yoyoEntity.field_70170_p.func_175698_g(pos)) {
            return null;
        }
        block.func_180663_b(world, pos, state);
        world.func_184133_a(null, pos, block.getSoundType(state, world, pos, (Entity)yoyoEntity).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        world.func_175718_b(2001, pos.func_185334_h(), Block.func_176210_f((IBlockState)state));
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)yoyo);
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, fortune);
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        yoyoEntity.increaseTimeout(10);
        return drops;
    }

    public static boolean attackEntity(ItemStack yoyo, EntityPlayer player, EnumHand hand, EntityYoyo yoyoEntity, Entity targetEntity) {
        if (!yoyoEntity.canAttack()) {
            return false;
        }
        if (!ForgeHooks.onPlayerAttackTarget((EntityPlayer)player, (Entity)targetEntity)) {
            return false;
        }
        UUID uuid = targetEntity.func_110124_au();
        if (uuid.equals(player.func_192023_dk().func_186857_a("UUID")) || uuid.equals(player.func_192025_dl().func_186857_a("UUID"))) {
            return false;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            yoyoEntity.resetAttackCooldown();
            yoyoEntity.increaseTimeout(10);
            yoyoEntity.getYoyo().damageItem(yoyo, 1, (EntityLivingBase)player);
            float damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float attackModifier = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)yoyo, (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)yoyo, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            if (damage > 0.0f || attackModifier > 0.0f) {
                int knockbackModifier = 0;
                knockbackModifier += EnchantmentHelper.func_77501_a((EntityLivingBase)player);
                boolean critical = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                boolean bl = critical = critical && !player.func_70051_ag();
                if (critical) {
                    damage *= 1.5f;
                }
                damage += attackModifier;
                float targetHealth = 0.0f;
                boolean setEntityOnFire = false;
                int fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (targetEntity instanceof EntityLivingBase) {
                    targetHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspect > 0 && !targetEntity.func_70027_ad()) {
                        setEntityOnFire = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double motionX = targetEntity.field_70159_w;
                double motionY = targetEntity.field_70181_x;
                double motionZ = targetEntity.field_70179_y;
                boolean didDamage = targetEntity.func_70097_a((DamageSource)new EntityDamageSourceIndirect("yoyo", (Entity)yoyoEntity, (Entity)player), damage);
                if (didDamage) {
                    if (knockbackModifier > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)player, (float)knockbackModifier * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f));
                        }
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = motionX;
                        targetEntity.field_70181_x = motionY;
                        targetEntity.field_70179_y = motionZ;
                    }
                    if (critical) {
                        player.field_70170_p.func_184148_a(null, yoyoEntity.field_70165_t, yoyoEntity.field_70163_u, yoyoEntity.field_70161_v, SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_71009_b(targetEntity);
                    }
                    if (!critical) {
                        player.field_70170_p.func_184148_a(null, yoyoEntity.field_70165_t, yoyoEntity.field_70163_u, yoyoEntity.field_70161_v, SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                    }
                    if (attackModifier > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)targetEntity);
                    if (yoyo != ItemStack.field_190927_a && targetEntity instanceof EntityLivingBase) {
                        yoyo.func_77961_a((EntityLivingBase)targetEntity, player);
                        if (yoyo.func_190916_E() <= 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)yoyo, (EnumHand)hand);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float f5 = targetHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        player.func_71064_a(StatList.field_188111_y, Math.round(f5 * 10.0f));
                        if (fireAspect > 0) {
                            targetEntity.func_70015_d(fireAspect * 4);
                        }
                        if (player.field_70170_p instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else {
                    player.field_70170_p.func_184148_a(null, yoyoEntity.field_70165_t, yoyoEntity.field_70163_u, yoyoEntity.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (setEntityOnFire) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
        return false;
    }
}

