/*
 * Decompiled with CFR 0.152.
 */
package net.flawedlogic.wildcrops.proxy;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.flawedlogic.wildcrops.worldgen.WildCropWorldGen;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    private HashMap<Block, String[]> _wildCrops = new HashMap();
    public HashMap<Block, Block[]> wildCrops = new HashMap();
    private Boolean wildCropsEnabled = true;
    public int wildCropsSpawnChance = 50;
    public int wildCropsMinPatchSize = 1;
    public int wildCropsMaxPatchSize = 1;
    public Boolean wildCropsOneCropPerSpawn = false;
    private Boolean showAvailableWildCrops = false;

    public void preinit(FMLPreInitializationEvent event) {
        Configuration config = null;
        File cfgFile = event.getSuggestedConfigurationFile();
        try {
            config = new Configuration(cfgFile);
            this.wildCropsEnabled = config.getBoolean("wildCropsEnabled", "general", true, "Enable wild crops");
            this.showAvailableWildCrops = config.getBoolean("showAvailableWildCrops", "general", false, "Show all available wild crop blocks (from all mods) in the log.");
            this.wildCropsSpawnChance = config.getInt("wildCropsSpawnChance", "general", 50, 0, 100, "Chance that a crop will spawn within a chunk");
            this.wildCropsMinPatchSize = config.getInt("wildCropsMinPatchSize", "general", 1, 1, 1, "Define the minimum size a patch of wild crops will be when they spawn");
            this.wildCropsMaxPatchSize = config.getInt("wildCropsMaxPatchSize", "general", 1, 1, 20, "Define the maximum size a patch of wild crops will be when they spawn");
            this.wildCropsOneCropPerSpawn = config.getBoolean("wildCropsOneCropPerSpawn", "general", false, "If true, only a single (random) crop will spawn within a given spawn area");
            config.getStringList("crops", "minecraft:air", new String[]{"minecraft:carrots"}, "This is an example, assigning carrots to air blocks, you can define as many base blocks as you want and what crops should grow on them, this example will not actually work as carrots can't grow in the air.");
            for (String categoryName : config.getCategoryNames()) {
                Block block;
                if (categoryName == "general" || (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(categoryName))) == Blocks.field_150350_a) continue;
                String[] crops = config.getStringList("crops", categoryName, new String[0], "");
                this._wildCrops.put(block, crops);
                FMLLog.info((String)"Adding %s to block %s", (Object[])new Object[]{crops, block});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (cfgFile.exists()) {
                cfgFile.delete();
            }
            config = new Configuration(cfgFile);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void init(FMLInitializationEvent event) {
        if (this.wildCropsEnabled.booleanValue()) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WildCropWorldGen(), (int)0);
        }
    }

    public void postinit(FMLPostInitializationEvent event) {
        if (this.showAvailableWildCrops.booleanValue()) {
            for (Block block : Block.field_149771_c) {
                if (!(block instanceof IGrowable)) continue;
                FMLLog.info((String)"Available Wild Crop: %s", (Object[])new Object[]{block.getRegistryName()});
            }
        }
        for (Block baseBlock : this._wildCrops.keySet()) {
            String[] _blocks = this._wildCrops.get(baseBlock);
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (int i = 0; i < _blocks.length; ++i) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(_blocks[i]));
                if (!(block instanceof IGrowable)) continue;
                FMLLog.info((String)"[WildCrops] Adding crop %s for block %s", (Object[])new Object[]{block.getRegistryName(), baseBlock.getRegistryName()});
                blocks.add(block);
            }
            if (blocks == null) continue;
            this.wildCrops.put(baseBlock, blocks.toArray(new Block[blocks.size()]));
        }
    }
}

