/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern.parameter;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum PatternParameterYDir implements IStatementParameter
{
    UP(true),
    DOWN(false);

    private static final PatternParameterYDir[] POSSIBLE_ORDER;
    public final boolean up;

    private PatternParameterYDir(boolean up) {
        this.up = up;
    }

    public static PatternParameterYDir readFromNbt(NBTTagCompound nbt) {
        if (nbt.func_74767_n("up")) {
            return UP;
        }
        return DOWN;
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74757_a("up", this.up);
    }

    public String getUniqueTag() {
        return "buildcraft:fillerParameterYDir";
    }

    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    public String getDescription() {
        return LocaleUtil.localize((String)("direction." + (this.up ? "up" : "down")));
    }

    public PatternParameterYDir onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    public IStatementParameter[] getPossible(IStatementContainer source) {
        return POSSIBLE_ORDER;
    }

    public boolean isPossibleOrdered() {
        return true;
    }

    public IStatementParameter rotateLeft() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        return this.up ? BCBuildersSprites.PARAM_STAIRS_UP : BCBuildersSprites.PARAM_STAIRS_DOWN;
    }

    static {
        POSSIBLE_ORDER = new PatternParameterYDir[]{null, null, UP, null, null, null, DOWN};
    }
}

