/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.filler.IFilledTemplate;
import buildcraft.api.filler.IFillerPatternShape;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.snapshot.pattern.Pattern;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterHollow;
import java.util.BitSet;

public class PatternSphere
extends Pattern
implements IFillerPatternShape {
    public PatternSphere() {
        super("sphere");
    }

    public ISprite getSprite() {
        return BCBuildersSprites.FILLER_SPHERE;
    }

    public int minParameters() {
        return 1;
    }

    public int maxParameters() {
        return 1;
    }

    public IStatementParameter createParameter(int index) {
        switch (index) {
            case 0: {
                return PatternParameterHollow.FILLED_INNER;
            }
        }
        return null;
    }

    public boolean fillTemplate(IFilledTemplate filledTemplate, IStatementParameter[] params) {
        PatternParameterHollow hollow = (PatternParameterHollow)PatternSphere.getParam((int)0, (IStatementParameter[])params, (IStatementParameter)PatternParameterHollow.FILLED_INNER);
        double cx = (double)filledTemplate.getMax().func_177958_n() / 2.0;
        double cy = (double)filledTemplate.getMax().func_177956_o() / 2.0;
        double cz = (double)filledTemplate.getMax().func_177952_p() / 2.0;
        double rx = cx + 0.5;
        double ry = cy + 0.5;
        double rz = cz + 0.5;
        BitSet data = null;
        if (hollow != PatternParameterHollow.FILLED_INNER) {
            data = new BitSet(Snapshot.getDataSize(filledTemplate.getSize()));
        }
        for (int x = 0; x <= filledTemplate.getMax().func_177958_n(); ++x) {
            double dx = Math.abs((double)x - cx) / rx;
            double dxx = dx * dx;
            for (int y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                double dy = Math.abs((double)y - cy) / ry;
                double dyy = dy * dy;
                for (int z = 0; z <= filledTemplate.getMax().func_177952_p(); ++z) {
                    double dz = Math.abs((double)z - cz) / rz;
                    double dzz = dz * dz;
                    if (!(dxx + dyy + dzz < 1.0)) continue;
                    if (hollow != PatternParameterHollow.FILLED_INNER) {
                        data.set(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z), true);
                        continue;
                    }
                    filledTemplate.set(x, y, z, true);
                }
            }
        }
        boolean outerFilled = hollow.outerFilled;
        if (hollow != PatternParameterHollow.FILLED_INNER) {
            int z;
            int x;
            for (x = 0; x <= filledTemplate.getMax().func_177958_n(); ++x) {
                block4: for (int y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                    int z2;
                    for (z2 = 0; z2 <= filledTemplate.getMax().func_177952_p(); ++z2) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z2))) {
                            filledTemplate.set(x, y, z2, true);
                            break;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x, y, z2, true);
                    }
                    for (z2 = filledTemplate.getMax().func_177952_p(); z2 >= 0; --z2) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z2))) {
                            filledTemplate.set(x, y, z2, true);
                            continue block4;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x, y, z2, true);
                    }
                }
            }
            for (x = 0; x <= filledTemplate.getMax().func_177958_n(); ++x) {
                block8: for (z = 0; z <= filledTemplate.getMax().func_177952_p(); ++z) {
                    int y;
                    for (y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z))) {
                            filledTemplate.set(x, y, z, true);
                            break;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x, y, z, true);
                    }
                    for (y = filledTemplate.getMax().func_177956_o(); y >= 0; --y) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z))) {
                            filledTemplate.set(x, y, z, true);
                            continue block8;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x, y, z, true);
                    }
                }
            }
            for (int y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                block12: for (z = 0; z <= filledTemplate.getMax().func_177952_p(); ++z) {
                    int x2;
                    for (x2 = 0; x2 <= filledTemplate.getMax().func_177958_n(); ++x2) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x2, y, z))) {
                            filledTemplate.set(x2, y, z, true);
                            break;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x2, y, z, true);
                    }
                    for (x2 = filledTemplate.getMax().func_177958_n(); x2 >= 0; --x2) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x2, y, z))) {
                            filledTemplate.set(x2, y, z, true);
                            continue block12;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x2, y, z, true);
                    }
                }
            }
        }
        return true;
    }
}

