/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern;

import buildcraft.api.filler.IFilledTemplate;
import buildcraft.api.filler.IFillerPatternShape;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.builders.snapshot.pattern.Pattern;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterCenter;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterYDir;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import java.util.EnumMap;
import java.util.Map;

public class PatternPyramid
extends Pattern
implements IFillerPatternShape {
    private static final Map<PatternParameterCenter, PyramidDir> PYRAMID_DIRS = new EnumMap<PatternParameterCenter, PyramidDir>(PatternParameterCenter.class);

    public PatternPyramid() {
        super("pyramid");
    }

    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCBuildersSprites.FILLER_PYRAMID;
    }

    public int maxParameters() {
        return 2;
    }

    public int minParameters() {
        return 2;
    }

    public IStatementParameter createParameter(int index) {
        switch (index) {
            case 0: {
                return PatternParameterYDir.UP;
            }
            case 1: {
                return PatternParameterCenter.CENTER;
            }
        }
        return null;
    }

    public boolean fillTemplate(IFilledTemplate filledTemplate, IStatementParameter[] params) {
        PyramidDir dir = params.length >= 2 && params[1] != null ? PYRAMID_DIRS.get((Object)((PatternParameterCenter)params[1])) : PYRAMID_DIRS.get((Object)PatternParameterCenter.CENTER);
        int stepY = params.length >= 1 && params[0] != null && !((PatternParameterYDir)params[0]).up ? -1 : 1;
        int xLower = 0;
        int xUpper = filledTemplate.getMax().func_177958_n();
        int zLower = 0;
        int zUpper = filledTemplate.getMax().func_177952_p();
        for (int y = stepY == 1 ? 0 : filledTemplate.getMax().func_177956_o(); y >= 0 && y <= filledTemplate.getMax().func_177956_o(); y += stepY) {
            filledTemplate.setAreaXZ(xLower, xUpper, y, zLower, zUpper, true);
            if ((xLower += dir.xLowerDiff) <= (xUpper += dir.xUpperDiff) && (zLower += dir.zLowerDiff) <= (zUpper += dir.zUpperDiff)) continue;
            break;
        }
        return true;
    }

    static {
        for (PatternParameterCenter param : PatternParameterCenter.values()) {
            PYRAMID_DIRS.put(param, new PyramidDir(param));
        }
    }

    private static class PyramidDir {
        public final int xLowerDiff;
        public final int xUpperDiff;
        public final int zLowerDiff;
        public final int zUpperDiff;

        public PyramidDir(PatternParameterCenter param) {
            this.xLowerDiff = param.offsetX >= 0 ? 1 : 0;
            this.xUpperDiff = param.offsetX <= 0 ? -1 : 0;
            this.zLowerDiff = param.offsetZ >= 0 ? 1 : 0;
            this.zUpperDiff = param.offsetZ <= 0 ? -1 : 0;
        }
    }
}

