/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.container.ContainerElectronicLibrary;
import buildcraft.builders.snapshot.GlobalSavedDataSnapshots;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.tile.TileElectronicLibrary;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.button.GuiButtonDrawable;
import buildcraft.lib.gui.button.IButtonClickEventTrigger;
import buildcraft.lib.gui.button.StandardSpriteButtons;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.LocaleUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.ResourceLocation;

public class GuiElectronicLibrary
extends GuiBC8<ContainerElectronicLibrary> {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftbuilders:textures/gui/electronic_library.png");
    private static final int SIZE_X = 244;
    private static final int SIZE_Y = 220;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0.0, 0.0, 244.0, 220.0);
    private static final GuiIcon ICON_PROGRESS_DOWN = new GuiIcon(TEXTURE_BASE, 234.0, 240.0, 22.0, 16.0);
    private static final GuiRectangle RECT_PROGRESS_DOWN = new GuiRectangle(194.0, 58.0, 22.0, 16.0);
    private static final GuiIcon ICON_PROGRESS_UP = new GuiIcon(TEXTURE_BASE, 234.0, 224.0, 22.0, 16.0);
    private static final GuiRectangle RECT_PROGRESS_UP = new GuiRectangle(194.0, 79.0, 22.0, 16.0);
    private final GuiButtonDrawable delButton;

    public GuiElectronicLibrary(ContainerElectronicLibrary container) {
        super((ContainerBC_Neptune)container);
        this.field_146999_f = 244;
        this.field_147000_g = 220;
        IGuiArea buttonPos = this.mainGui.rootElement.offset(174.0, 109.0);
        this.delButton = new GuiButtonDrawable(this.mainGui, "del", (IGuiPosition)buttonPos, StandardSpriteButtons.EIGHTH_BUTTON_DRAWABLE);
        this.delButton.enabled = false;
        this.delButton.registerListener(this::onDelButtonClick);
        this.mainGui.shownElements.add(this.delButton);
        this.mainGui.shownElements.add(this.delButton.createTextElement(LocaleUtil.localize((String)"gui.del")));
    }

    private void onDelButtonClick(IButtonClickEventTrigger button, int buttonKey) {
        Snapshot snapshot;
        if (((TileElectronicLibrary)((ContainerElectronicLibrary)this.container).tile).selected != null && (snapshot = this.getSnapshots().getSnapshot(((TileElectronicLibrary)((ContainerElectronicLibrary)this.container).tile).selected)) != null) {
            ((ContainerElectronicLibrary)this.container).sendSelectedToServer(null);
            this.getSnapshots().removeSnapshot(snapshot.key);
        }
    }

    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt((IGuiPosition)this.mainGui.rootElement);
        this.drawProgress(RECT_PROGRESS_DOWN, ICON_PROGRESS_DOWN, -((TileElectronicLibrary)((ContainerElectronicLibrary)this.container).tile).deltaProgressDown.getDynamic(partialTicks), 1.0);
        this.drawProgress(RECT_PROGRESS_UP, ICON_PROGRESS_UP, ((TileElectronicLibrary)((ContainerElectronicLibrary)this.container).tile).deltaProgressUp.getDynamic(partialTicks), 1.0);
        this.iterateSnapshots((i, rect, key) -> {
            boolean isSelected = key.equals(((TileElectronicLibrary)((ContainerElectronicLibrary)this.container).tile).selected);
            if (isSelected) {
                this.drawGradientRect((IGuiArea)rect, -11184811, -11184811);
            }
            int colour = isSelected ? 0xFFFFA0 : 0xE0E0E0;
            Snapshot.Header header = key.header;
            String text = header == null ? key.toString() : header.name;
            this.drawString(this.field_146289_q, text, rect.x, rect.y, colour);
        });
        this.delButton.enabled = this.getSnapshots().getSnapshot(((TileElectronicLibrary)((ContainerElectronicLibrary)this.container).tile).selected) != null;
    }

    private GlobalSavedDataSnapshots getSnapshots() {
        return GlobalSavedDataSnapshots.get(((TileElectronicLibrary)((ContainerElectronicLibrary)this.container).tile).func_145831_w());
    }

    private void iterateSnapshots(ISnapshotIterator iterator) {
        List<Snapshot.Key> list = this.getSnapshots().getList();
        GuiRectangle rect = new GuiRectangle(this.mainGui.rootElement.getX() + 8.0, this.mainGui.rootElement.getY() + 22.0, 154.0, 8.0);
        for (int i = 0; i < list.size(); ++i) {
            iterator.call(i, rect, list.get(i));
            rect = rect.offset(0.0, 8.0);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        AtomicBoolean found = new AtomicBoolean(false);
        this.iterateSnapshots((i, rect, key) -> {
            if (rect.contains((IGuiPosition)this.mainGui.mouse)) {
                ((ContainerElectronicLibrary)this.container).sendSelectedToServer(key);
                this.delButton.enabled = true;
                found.set(true);
            }
        });
        if (!found.get()) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    @FunctionalInterface
    private static interface ISnapshotIterator {
        public void call(int var1, GuiRectangle var2, Snapshot.Key var3);
    }
}

