/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.util.List;
import net.darkhax.wawla.config.Configurable;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.darkhax.wawla.plugins.ProviderType;
import net.darkhax.wawla.plugins.WawlaFeature;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

@WawlaFeature(description="Shows info about the furnace", name="furnace", type=ProviderType.BLOCK)
public class PluginFurnace
extends InfoProvider {
    @Configurable(category="furnace", description="Show the stack in the fuel slot?")
    public static boolean fuel = true;
    @Configurable(category="furnace", description="Show the stack in the input slot?")
    public static boolean input = true;
    @Configurable(category="furnace", description="Show the stack in the output slot?")
    public static boolean output = true;
    @Configurable(category="furnace", description="Show the remaining fuel time?")
    public static boolean burntime = true;

    @Override
    public void addTileInfo(List<String> info, InfoAccess data) {
        if (data.world.func_175625_s(data.pos) instanceof TileEntityFurnace) {
            int time;
            ItemStack stack;
            if (input && !(stack = new ItemStack(data.tag.func_74775_l("InputStack"))).func_190926_b()) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.input", (Object[])new Object[0]) + ": " + stack.func_82833_r() + " * " + stack.func_190916_E());
            }
            if (fuel && !(stack = new ItemStack(data.tag.func_74775_l("FuelStack"))).func_190926_b()) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.fuel", (Object[])new Object[0]) + ": " + stack.func_82833_r() + " * " + stack.func_190916_E());
            }
            if (output && !(stack = new ItemStack(data.tag.func_74775_l("OutputStack"))).func_190926_b()) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.output", (Object[])new Object[0]) + ": " + stack.func_82833_r() + " * " + stack.func_190916_E());
            }
            if (burntime && (time = data.tag.func_74762_e("BurnTime")) > 0) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.burntime", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)time));
            }
        }
    }

    @Override
    public void writeTileNBT(World world, TileEntity tile, NBTTagCompound tag) {
        if (tile instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)tile;
            ItemStack stack = null;
            if (input && (stack = furnace.func_70301_a(0)) != null) {
                InfoProvider.writeStackToTag(stack, "InputStack", tag);
            }
            if (fuel && (stack = furnace.func_70301_a(1)) != null) {
                InfoProvider.writeStackToTag(stack, "FuelStack", tag);
            }
            if (output && (stack = furnace.func_70301_a(2)) != null) {
                InfoProvider.writeStackToTag(stack, "OutputStack", tag);
            }
            tag.func_74768_a("BurnTime", furnace.func_174887_a_(0));
        }
    }

    @Override
    public boolean requireTileSync(World world, TileEntity tile) {
        return tile instanceof TileEntityFurnace;
    }
}

