/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.reinforcement;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.pickletweaks.config.ModConfig;
import com.blakebr0.pickletweaks.feature.reinforcement.ReinforcementHelper;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReinforcementHandler {
    public static final Map<ItemStack, Integer> REINFORCEMENTS = new HashMap<ItemStack, Integer>();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!ReinforcementHelper.isReinforceable(stack.func_77973_b())) {
            return;
        }
        ListIterator<String> itr = event.getToolTip().listIterator();
        if (ReinforcementHelper.isReinforced(stack) && itr.hasNext()) {
            itr.next();
            itr.add(Utils.localize((String)"tooltip.pt.reinforced", (Object[])new Object[]{ReinforcementHelper.getReinforcement(stack), ModConfig.confMaxReinforcement}));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltipAsWell(ItemTooltipEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!ReinforcementHelper.isReinforcement(stack)) {
            return;
        }
        ListIterator<String> itr = event.getToolTip().listIterator();
        if (itr.hasNext()) {
            itr.next();
            itr.add(Utils.localize((String)"tooltip.pt.reinforce", (Object[])new Object[]{"\u00a7f" + ReinforcementHelper.getReinforcementValue(stack)}));
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!this.blockBreakTool(stack.func_77973_b())) {
            return;
        }
        if (!this.isBlockHardEnough(event.getState(), event.getWorld(), event.getPos())) {
            return;
        }
        if (ReinforcementHelper.isReinforced(stack) && stack.func_77951_h()) {
            int extra = ReinforcementHelper.useReinforcement(stack, stack.func_77973_b() instanceof ItemSword ? 2 : 1);
            stack.func_77964_b(ReinforcementHelper.getDurability(stack) + extra);
        }
    }

    @SubscribeEvent
    public void onHitEntity(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (!source.func_76355_l().equals("player")) {
            return;
        }
        if (!(source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)source.func_76346_g();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!this.hitEntityTool(stack.func_77973_b())) {
            return;
        }
        if (ReinforcementHelper.isReinforced(stack) && stack.func_77951_h()) {
            int extra = ReinforcementHelper.useReinforcement(stack, stack.func_77973_b() instanceof ItemTool ? 2 : 1);
            stack.func_77964_b(ReinforcementHelper.getDurability(stack) + extra);
        }
    }

    public void onUseHoe(UseHoeEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemHoe)) {
            return;
        }
        if (ReinforcementHelper.isReinforced(stack) && stack.func_77951_h()) {
            int extra = ReinforcementHelper.useReinforcement(stack, 1);
            stack.func_77964_b(ReinforcementHelper.getDurability(stack) + extra);
        }
    }

    public void onUseBow(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemBow)) {
            return;
        }
        if (ReinforcementHelper.isReinforced(stack) && stack.func_77951_h()) {
            int extra = ReinforcementHelper.useReinforcement(stack, 1);
            stack.func_77964_b(ReinforcementHelper.getDurability(stack) + extra);
        }
    }

    private boolean isBlockHardEnough(IBlockState state, World world, BlockPos pos) {
        return state.func_185887_b(world, pos) != 0.0f;
    }

    private boolean isHoeWorking(World world, BlockPos pos, Event.Result result) {
        if (result == Event.Result.ALLOW) {
            return true;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_185774_da;
    }

    private boolean blockBreakTool(Item tool) {
        return tool instanceof ItemTool || tool instanceof ItemSword;
    }

    private boolean hitEntityTool(Item tool) {
        return tool instanceof ItemTool || tool instanceof ItemSword || tool instanceof ItemHoe;
    }
}

