/*
 * Decompiled with CFR 0.152.
 */
package uppers.tiles;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import uppers.blocks.BlockUpper;
import uppers.tiles.TileEntityUpper;

public class InventoryCodeHooksTweaked {
    @Nullable
    public static Boolean extractHook(IHopper dest) {
        Pair<IItemHandler, Object> itemHandlerResult = InventoryCodeHooksTweaked.getItemHandler(dest, EnumFacing.DOWN);
        if (itemHandlerResult == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractItem = handler.extractItem(i, 1, true);
            if (extractItem.func_190926_b()) continue;
            for (int j = 0; j < dest.func_70302_i_(); ++j) {
                ItemStack destStack = dest.func_70301_a(j);
                if (!dest.func_94041_b(j, extractItem) || !destStack.func_190926_b() && (destStack.func_190916_E() >= destStack.func_77976_d() || destStack.func_190916_E() >= dest.func_70297_j_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = handler.extractItem(i, 1, false);
                if (destStack.func_190926_b()) {
                    dest.func_70299_a(j, extractItem);
                } else {
                    destStack.func_190917_f(1);
                    dest.func_70299_a(j, destStack);
                }
                dest.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public static boolean insertHook(TileEntityUpper tileEntityUpper) {
        EnumFacing upperFacing = BlockUpper.getFacing(tileEntityUpper.func_145832_p());
        Pair<IItemHandler, Object> destinationResult = InventoryCodeHooksTweaked.getItemHandler(tileEntityUpper, upperFacing);
        if (destinationResult == null) {
            return false;
        }
        IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
        Object destination = destinationResult.getValue();
        if (InventoryCodeHooksTweaked.isFull(itemHandler)) {
            return false;
        }
        for (int i = 0; i < tileEntityUpper.func_70302_i_(); ++i) {
            if (tileEntityUpper.func_70301_a(i).func_190926_b()) continue;
            ItemStack originalSlotContents = tileEntityUpper.func_70301_a(i).func_77946_l();
            ItemStack insertStack = tileEntityUpper.func_70298_a(i, 1);
            ItemStack remainder = InventoryCodeHooksTweaked.putStackInInventoryAllSlots((TileEntity)tileEntityUpper, destination, itemHandler, insertStack);
            if (remainder.func_190926_b()) {
                return true;
            }
            tileEntityUpper.func_70299_a(i, originalSlotContents);
        }
        return false;
    }

    private static ItemStack putStackInInventoryAllSlots(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.func_190926_b(); ++slot) {
            stack = InventoryCodeHooksTweaked.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).func_190926_b()) {
            TileEntityUpper destinationUpper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = InventoryCodeHooksTweaked.isEmpty(destInventory);
            if (itemstack.func_190926_b()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.field_190927_a;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.func_190916_E();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).func_190916_E();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof TileEntityUpper && !(destinationUpper = (TileEntityUpper)((Object)destination)).mayTransfer()) {
                int k = 0;
                if (source instanceof TileEntityUpper && destinationUpper.getLastUpdateTime() >= ((TileEntityUpper)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationUpper.setTransferCooldown(8 - k);
            }
        }
        return stack;
    }

    @Nullable
    private static Pair<IItemHandler, Object> getItemHandler(IHopper upper, EnumFacing upperFacing) {
        double x = upper.func_96107_aA() + (double)upperFacing.func_82601_c();
        double y = upper.func_96109_aB() + (double)upperFacing.func_96559_d();
        double z = upper.func_96108_aC() + (double)upperFacing.func_82599_e();
        return InventoryCodeHooksTweaked.getItemHandler(upper.func_145831_w(), x, y, z, upperFacing.func_176734_d());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_190916_E() == stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.func_190916_E() <= 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<IItemHandler, Object> getItemHandler(World worldIn, double x, double y, double z, EnumFacing side) {
        TileEntity tileentity;
        int k;
        int j;
        ImmutablePair destination = null;
        int i = MathHelper.func_76128_c((double)x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z));
        IBlockState state = worldIn.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state) && (tileentity = worldIn.func_175625_s(blockpos)) != null && tileentity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler capability = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            destination = ImmutablePair.of((Object)capability, (Object)tileentity);
        }
        return destination;
    }
}

