/*
 * Decompiled with CFR 0.152.
 */
package uk.bobbytables.zenloot.crafttweaker.zenscript;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import stanhebben.zenscript.annotations.ZenClass;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootEntry;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootPool;

@ZenRegister
@ZenClass(value="mods.zenloot.LootPoolExisting")
public class MCLootPoolExisting
extends MCLootPool {
    private static final Field poolConditionsField = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186454_b");
    private Boolean clearFlag = false;
    private RandomValueRange rolls = null;
    private RandomValueRange bonusRolls = null;

    public MCLootPoolExisting(String name) {
        super(name);
    }

    @Override
    public void process(LootTable table, ResourceLocation tableLoc) {
        LootPool pool = table.getPool(this.getName());
        if (pool == null) {
            CraftTweakerAPI.logError((String)String.format("Tried to modify a pool (%s) that doesn't exist in table %s", this.getName(), tableLoc));
            return;
        }
        if (this.clearFlag.booleanValue()) {
            table.removePool(this.getName());
            try {
                pool = new LootPool(new LootEntry[0], ((List)poolConditionsField.get(pool)).toArray(new LootCondition[0]), pool.getRolls(), pool.getBonusRolls(), this.getName());
            }
            catch (IllegalAccessException e) {
                CraftTweakerAPI.logError((String)"Error retrieving pool conditions");
                pool = new LootPool(new LootEntry[0], new LootCondition[0], pool.getRolls(), pool.getBonusRolls(), this.getName());
            }
            table.addPool(pool);
        }
        if (this.rolls != null) {
            pool.setRolls(this.rolls);
        }
        if (this.bonusRolls != null) {
            pool.setBonusRolls(this.bonusRolls);
        }
        for (MCLootEntry lootEntry : this.lootEntries) {
            pool.addEntry(lootEntry.build());
        }
        if (this.rolls != null) {
            pool.setRolls(this.rolls);
        }
        if (this.bonusRolls != null) {
            pool.setBonusRolls(this.bonusRolls);
        }
    }

    @Override
    public MCLootPool clear() {
        this.clearFlag = true;
        return super.clear();
    }

    @Override
    public MCLootPool setRolls(int min, int max) {
        this.rolls = new RandomValueRange((float)min, (float)max);
        return super.setRolls(min, max);
    }

    @Override
    public MCLootPool setBonusRolls(int min, int max) {
        this.bonusRolls = new RandomValueRange((float)min, (float)max);
        return super.setBonusRolls(min, max);
    }
}

