/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat;

import java.util.Arrays;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.MarketRegistryDefaultHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;

public class AgriCraftAddon {
    private static final String KEY_SEEDS = "AgriCraft Seeds";

    public AgriCraftAddon() {
        FarmingForBlockheadsAPI.registerMarketDefaultHandler(KEY_SEEDS, new MarketRegistryDefaultHandler(){

            @Override
            public void apply(ItemStack defaultPayment) {
                this.apply(defaultPayment, 1);
            }

            @Override
            public void apply(ItemStack defaultPayment, int defaultAmount) {
                Item seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("agricraft", "agri_seed"));
                if (seedItem != null) {
                    CreativeTabs agriCraftTab = Arrays.stream(CreativeTabs.field_78032_a).filter(tab -> tab.field_78034_o.equals("agricraft_seeds")).findFirst().orElse(null);
                    if (agriCraftTab != null) {
                        NonNullList stackList = NonNullList.func_191196_a();
                        seedItem.func_150895_a(agriCraftTab, stackList);
                        for (ItemStack itemStack : stackList) {
                            FarmingForBlockheadsAPI.registerMarketEntry(ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)defaultAmount), defaultPayment, FarmingForBlockheadsAPI.getMarketCategorySeeds());
                        }
                    } else {
                        FarmingForBlockheads.logger.warn("Could not find AgriCraft Seeds creative tab. AgriCraft seeds will not be available in the market.");
                    }
                } else {
                    FarmingForBlockheads.logger.warn("Could not find AgriCraft seed item. AgriCraft seeds will not be available in the market.");
                }
            }

            @Override
            public boolean isEnabledByDefault() {
                return false;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC, 2);
            }
        });
    }
}

