/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.stager.type;

import com.blamejared.recipestages.handlers.Recipes;
import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.util.ModUtils;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.itemstages.compat.crt.ActionAddItemRestriction;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import uk.artdude.zenstages.stager.ZenStager;
import uk.artdude.zenstages.stager.type.TypeBase;

public class TypeMod
extends TypeBase<String> {
    private boolean stageRecipesWithItems;
    private Map<ResourceLocation, List<IItemStack>> overrides = new HashMap<ResourceLocation, List<IItemStack>>();

    public TypeMod(String modId, boolean stageRecipesWithItems, IIngredient ... overrides) {
        super(modId);
        for (IIngredient override : overrides) {
            for (IItemStack item : override.getItems()) {
                ResourceLocation resourceLocation = new ResourceLocation(item.getDefinition().getId());
                if (this.overrides.containsKey(resourceLocation)) {
                    this.overrides.get(resourceLocation).add(item);
                    continue;
                }
                this.overrides.put(resourceLocation, Lists.newArrayList((Object[])new IItemStack[]{item}));
            }
        }
        this.stageRecipesWithItems = stageRecipesWithItems;
    }

    @Override
    public void build(String stageName) {
        for (MCItemStack mcItemStack : ModUtils.getSortedEntries((IForgeRegistry)ForgeRegistries.ITEMS).get(this.getValue()).stream().flatMap(item -> Arrays.stream(StackUtils.getAllItems((Item)item))).map(MCItemStack::createNonCopy).collect(Collectors.toList())) {
            ResourceLocation resourceLocation = new ResourceLocation(mcItemStack.getDefinition().getId());
            if (this.overrides.containsKey(resourceLocation) && this.overrides.get(resourceLocation).stream().anyMatch(iItemStack -> iItemStack.matches((IItemStack)mcItemStack)) || ZenStager.modItemOverrides.containsKey(this.getValue()) && ZenStager.modItemOverrides.get(this.getValue()).containsKey(resourceLocation) && ZenStager.modItemOverrides.get(this.getValue()).get(resourceLocation).stream().anyMatch(iItemStack -> iItemStack.matches((IItemStack)mcItemStack))) continue;
            CraftTweakerAPI.apply((IAction)new ActionAddItemRestriction(stageName, (IIngredient)mcItemStack));
            if (!this.stageRecipesWithItems) continue;
            Recipes.setRecipeStage((String)stageName, (IIngredient)mcItemStack);
        }
    }

    @Override
    public void build(String[] stageNames) {
    }

    @Override
    public void buildRecipe(String stageName) {
    }
}

