/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.progressiontweaks.registries;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class FirePitRegistry {
    public static final FirePitRegistry INSTANCE = new FirePitRegistry();
    private Map<ItemStack, CookingResult> cookingRegistry = new HashMap<ItemStack, CookingResult>();
    private Map<ItemStack, Integer> cookingFuelRegistry = new HashMap<ItemStack, Integer>();

    public void clearRegistry() {
        this.cookingRegistry.clear();
        this.cookingFuelRegistry.clear();
    }

    public void registerCookingRecipe(ItemStack input, ItemStack result, int duration, int xp) {
        this.cookingRegistry.put(input, new CookingResult(result, duration, xp));
    }

    public void registerFuel(ItemStack fuel, int burnTime) {
        this.cookingFuelRegistry.put(fuel, burnTime);
    }

    public CookingResult getResultFromInput(ItemStack input) {
        if (input == null) {
            return null;
        }
        CookingResult result = null;
        for (ItemStack stack : this.cookingRegistry.keySet()) {
            if (!stack.func_77973_b().equals(input.func_77973_b()) || stack.func_77952_i() != input.func_77952_i()) continue;
            result = this.cookingRegistry.get(stack);
        }
        return result;
    }

    public int getBurnTimeFromFuel(ItemStack input) {
        if (input == null) {
            return -1;
        }
        int result = -1;
        for (ItemStack stack : this.cookingFuelRegistry.keySet()) {
            if (!stack.func_77973_b().equals(input.func_77973_b()) || stack.func_77952_i() != input.func_77952_i()) continue;
            result = this.cookingFuelRegistry.get(stack);
        }
        return result;
    }

    public static class CookingResult {
        private ItemStack result;
        private int duration;
        private int xp;

        public CookingResult(ItemStack result, int duration, int xp) {
            this.result = result;
            this.duration = duration;
            this.xp = xp;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getXp() {
            return this.xp;
        }
    }
}

