/*
 * Decompiled with CFR 0.152.
 */
package com.theprogrammingturkey.progressiontweaks.blocks.tileentities;

import com.theprogrammingturkey.gobblecore.IModCore;
import com.theprogrammingturkey.gobblecore.network.NetworkManager;
import com.theprogrammingturkey.gobblecore.util.Scheduler;
import com.theprogrammingturkey.gobblecore.util.Task;
import com.theprogrammingturkey.progressiontweaks.ProgressionCore;
import com.theprogrammingturkey.progressiontweaks.blocks.ProgressionBlocks;
import com.theprogrammingturkey.progressiontweaks.config.ProgressionSettings;
import com.theprogrammingturkey.progressiontweaks.network.PacketUdateFirePit;
import com.theprogrammingturkey.progressiontweaks.registries.FirePitRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileFirePit
extends TileEntity
implements ITickable {
    private ItemStack cooking;
    private int burnTimeLeft = -1;
    private int cookTimeLeft = -1;

    public TileFirePit() {
        Scheduler.scheduleTask((Task)new Task("Fire_Pit_Mob_Attract", -1, 20){

            public void callback() {
            }

            public void update() {
                if (!((TileFirePit)TileFirePit.this).field_145850_b.field_72995_K) {
                    if (TileFirePit.this.field_145850_b == null) {
                        Scheduler.removeTask((Task)this);
                        return;
                    }
                    TileEntity tileentity = TileFirePit.this.field_145850_b.func_175625_s(TileFirePit.this.field_174879_c);
                    if (tileentity != null && tileentity.equals((Object)TileFirePit.this)) {
                        EntityPlayer toAttack = null;
                        for (EntityPlayer player : ((TileFirePit)TileFirePit.this).field_145850_b.field_73010_i) {
                            if (!(player.func_180425_c().func_177951_i((Vec3i)TileFirePit.this.func_174877_v()) < 10.0)) continue;
                            toAttack = player;
                            break;
                        }
                        if (toAttack != null) {
                            int radius = ProgressionSettings.firePitAttractionRadius;
                            List entities = TileFirePit.this.field_145850_b.func_72872_a(EntityMob.class, new AxisAlignedBB(TileFirePit.this.func_174877_v().func_177982_a(radius, radius, radius), TileFirePit.this.func_174877_v().func_177982_a(-radius, -radius, -radius)));
                            for (EntityMob ent : entities) {
                                if (ent.func_70638_az() != null) continue;
                                ent.func_70624_b((EntityLivingBase)toAttack);
                            }
                        }
                    } else {
                        Scheduler.removeTask((Task)this);
                    }
                }
            }
        });
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            FirePitRegistry.CookingResult result;
            if (this.field_145850_b.func_175727_C(this.field_174879_c.func_177982_a(0, 1, 0))) {
                if (this.burnTimeLeft > 0) {
                    this.burnTimeLeft = -1;
                    this.cookTimeLeft = -1;
                    TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c);
                    this.field_145850_b.func_175656_a(this.field_174879_c, ProgressionBlocks.FIRE_PIT_UNLIT.func_176223_P());
                    this.field_145850_b.func_175656_a(this.field_174879_c, ProgressionBlocks.FIRE_PIT_UNLIT.func_176223_P());
                    tileentity.func_145829_t();
                    this.field_145850_b.func_175690_a(this.field_174879_c, tileentity);
                    this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    this.sendUpdatePacket();
                }
                return;
            }
            if (this.burnTimeLeft > 0) {
                --this.burnTimeLeft;
                if (this.cookTimeLeft > 0) {
                    --this.cookTimeLeft;
                }
            }
            if (this.burnTimeLeft == 0) {
                TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c);
                this.field_145850_b.func_175656_a(this.field_174879_c, ProgressionBlocks.FIRE_PIT_UNLIT.func_176223_P());
                this.field_145850_b.func_175656_a(this.field_174879_c, ProgressionBlocks.FIRE_PIT_UNLIT.func_176223_P());
                tileentity.func_145829_t();
                this.field_145850_b.func_175690_a(this.field_174879_c, tileentity);
                this.burnTimeLeft = -1;
                this.sendUpdatePacket();
            }
            if (this.cookTimeLeft == 0 && (result = FirePitRegistry.INSTANCE.getResultFromInput(this.cooking)) != null) {
                this.setCooking(result.getResult());
                this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), result.getXp()));
                this.cookTimeLeft = -1;
                this.sendUpdatePacket();
            }
        }
    }

    public boolean isCooking() {
        return this.burnTimeLeft > 0;
    }

    public ItemStack getItemCooking() {
        return this.cooking == null ? null : this.cooking.func_77946_l();
    }

    public void startCooking(ItemStack stack, int duration) {
        this.cooking = stack.func_77946_l();
        this.cooking.func_190920_e(1);
        this.cookTimeLeft = duration;
    }

    public void setCooking(ItemStack stack) {
        if (stack != null) {
            this.cooking = stack.func_77946_l();
            this.cooking.func_190920_e(1);
        } else {
            this.cooking = null;
        }
    }

    public void addBurnTime(int burnTime) {
        if (this.burnTimeLeft <= 0) {
            this.burnTimeLeft = burnTime;
            this.field_145850_b.func_175656_a(this.field_174879_c, ProgressionBlocks.FIRE_PIT_LIT.func_176223_P());
            this.field_145850_b.func_175656_a(this.field_174879_c, ProgressionBlocks.FIRE_PIT_LIT.func_176223_P());
            this.func_145829_t();
            this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)this);
        } else {
            this.burnTimeLeft += burnTime;
        }
        this.sendUpdatePacket();
    }

    public void sendUpdatePacket() {
        Scheduler.scheduleTask((Task)new Task("Delayed Packet", 2){

            public void callback() {
                NetworkManager.getSimpleNetwork((IModCore)ProgressionCore.instance).sendToAll((IMessage)new PacketUdateFirePit(TileFirePit.this.getItemCooking(), TileFirePit.this.getBurnTimeLeft(), TileFirePit.this.getCookTimeLeft(), TileFirePit.this.func_174877_v().func_177958_n(), TileFirePit.this.func_174877_v().func_177956_o(), TileFirePit.this.func_174877_v().func_177952_p()));
            }
        });
    }

    public void setBurnTimeLeft(int burnTime) {
        this.burnTimeLeft = burnTime;
    }

    public int getBurnTimeLeft() {
        return this.burnTimeLeft;
    }

    public void setCookTimeLeft(int cookTimeLeft) {
        this.cookTimeLeft = cookTimeLeft;
    }

    public int getCookTimeLeft() {
        return this.cookTimeLeft;
    }

    public void dropCurrentItem(EntityPlayer player) {
        if (this.cooking != null) {
            EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.cooking.func_77946_l());
            entityitem.func_174867_a(5);
            player.field_70170_p.func_72838_d((Entity)entityitem);
            this.cooking = null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74768_a("burnTime", this.burnTimeLeft);
        nbt.func_74768_a("cookTimeLeft", this.cookTimeLeft);
        NBTTagCompound cookingNBT = new NBTTagCompound();
        if (this.cooking != null) {
            this.cooking.func_77955_b(cookingNBT);
        }
        nbt.func_74782_a("cookingItem", (NBTBase)cookingNBT);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.burnTimeLeft = nbt.func_74762_e("burnTime");
        this.cookTimeLeft = nbt.func_74762_e("cookTimeLeft");
        if (nbt.func_74781_a("cookingItem") != null) {
            this.cooking = new ItemStack((NBTTagCompound)nbt.func_74781_a("cookingItem"));
        }
        if (!ProgressionCore.proxy.isClient()) {
            this.sendUpdatePacket();
        }
    }
}

