/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.google.common.primitives.Ints;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GuiAmountSpecifying
extends GuiBase {
    protected GuiTextField amountField;
    private GuiBase parent;
    protected GuiButton okButton;
    private GuiButton cancelButton;
    private GuiButton[] incrementButtons = new GuiButton[6];

    public GuiAmountSpecifying(GuiBase parent, Container container, int width, int height) {
        super(container, width, height);
        this.parent = parent;
    }

    protected abstract String getOkButtonText();

    protected abstract String getTitle();

    protected abstract String getTexture();

    protected abstract int[] getIncrements();

    protected abstract int getDefaultAmount();

    protected abstract boolean canAmountGoNegative();

    protected abstract int getMaxAmount();

    protected Pair<Integer, Integer> getAmountPos() {
        return Pair.of((Object)9, (Object)51);
    }

    protected Pair<Integer, Integer> getOkCancelPos() {
        return Pair.of((Object)114, (Object)33);
    }

    @Override
    public void init(int x, int y) {
        String text;
        int i;
        Pair<Integer, Integer> pos = this.getOkCancelPos();
        this.okButton = this.addButton(x + (Integer)pos.getLeft(), y + (Integer)pos.getRight(), 50, 20, this.getOkButtonText());
        this.cancelButton = this.addButton(x + (Integer)pos.getLeft(), y + (Integer)pos.getRight() + 24, 50, 20, GuiAmountSpecifying.t("gui.cancel", new Object[0]));
        this.amountField = new GuiTextField(0, this.field_146289_q, x + (Integer)this.getAmountPos().getLeft(), y + (Integer)this.getAmountPos().getRight(), 63, this.field_146289_q.field_78288_b);
        this.amountField.func_146185_a(false);
        this.amountField.func_146189_e(true);
        this.amountField.func_146180_a(String.valueOf(this.getDefaultAmount()));
        this.amountField.func_146193_g(0xFFFFFF);
        this.amountField.func_146205_d(false);
        this.amountField.func_146195_b(true);
        int[] increments = this.getIncrements();
        int xx = 7;
        int width = 30;
        for (i = 0; i < 3; ++i) {
            text = "+" + increments[i];
            if (text.equals("+1000")) {
                text = "+1B";
            }
            this.incrementButtons[i] = this.addButton(x + xx, y + 20, width, 20, text);
            xx += width + 3;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            text = "-" + increments[i];
            if (text.equals("-1000")) {
                text = "-1B";
            }
            this.incrementButtons[3 + i] = this.addButton(x + xx, y + this.screenHeight - 20 - 7, width, 20, text);
            xx += width + 3;
        }
    }

    @Override
    public void update(int x, int y) {
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture(this.getTexture());
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        this.amountField.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, this.getTitle());
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (this.func_146983_a(keyCode) || !this.amountField.func_146201_a(character, keyCode)) {
            if (keyCode == 28) {
                this.onOkButtonPressed(GuiAmountSpecifying.func_146272_n());
            } else if (keyCode == 1) {
                this.close();
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.okButton.field_146127_k) {
            this.onOkButtonPressed(GuiAmountSpecifying.func_146272_n());
        } else if (button.field_146127_k == this.cancelButton.field_146127_k) {
            this.close();
        } else {
            for (GuiButton incrementButton : this.incrementButtons) {
                String incrementButtonText;
                if (incrementButton.field_146127_k != button.field_146127_k) continue;
                Integer oldAmount = Ints.tryParse((String)this.amountField.func_146179_b());
                if (oldAmount == null) {
                    oldAmount = 0;
                }
                if ((incrementButtonText = incrementButton.field_146126_j).equals("+1B")) {
                    incrementButtonText = "1000";
                } else if (incrementButtonText.equals("-1B")) {
                    incrementButtonText = "-1000";
                }
                int newAmount = Integer.parseInt(incrementButtonText);
                newAmount = !this.canAmountGoNegative() ? Math.max(1, (oldAmount == 1 && newAmount != 1 ? 0 : oldAmount) + newAmount) : oldAmount + newAmount;
                if (newAmount > this.getMaxAmount()) {
                    newAmount = this.getMaxAmount();
                }
                this.amountField.func_146180_a(String.valueOf(newAmount));
                break;
            }
        }
    }

    protected void onOkButtonPressed(boolean shiftDown) {
    }

    public void close() {
        FMLClientHandler.instance().showGuiScreen((Object)this.parent);
    }

    public GuiBase getParent() {
        return this.parent;
    }
}

