/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.api.util.impl.BlockColorProvider;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.util.ReflectionLib;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ColorUtils {
    public static final PropertyEnum<EnumDyeColor> COLOR = BlockColored.field_176581_a;
    private static final EnumDyeColor[] DYES = EnumDyeColor.values();
    public static HashMap<BlockIngredient, DyeAmount> FLOWER_TO_DYES = Maps.newHashMap();
    private static HashMap<String, EnumDyeColor> DYE_CACHE = Maps.newHashMap();

    private static void addFlower(BlockIngredient ingredient, DyeAmount dyeAmount) {
        FLOWER_TO_DYES.put(ingredient, dyeAmount);
    }

    private static void addFlower(BlockDoublePlant.EnumPlantType type, DyeAmount dyeAmount) {
        ItemStack flower = new ItemStack((Block)Blocks.field_150398_cm, 1, type.func_176936_a());
        ColorUtils.addFlower(new BlockIngredient(flower), dyeAmount);
    }

    private static void addFlower(BlockFlower.EnumFlowerType type, DyeAmount dyeAmount) {
        ItemStack flower = new ItemStack((Block)(type.func_176964_a() == BlockFlower.EnumFlowerColor.YELLOW ? Blocks.field_150327_N : Blocks.field_150328_O), 1, type.func_176968_b());
        ColorUtils.addFlower(new BlockIngredient(flower), dyeAmount);
    }

    public static ItemStack getDye(EnumDyeColor color, int count) {
        return new ItemStack(Items.field_151100_aR, count, color.func_176767_b());
    }

    @Nullable
    private static EnumDyeColor getDye(String dyeOredict) {
        if (!DYE_CACHE.containsKey(dyeOredict)) {
            for (EnumDyeColor dye : DYES) {
                String oredict = String.format("dye%s", CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, dye.func_176762_d()));
                if (!oredict.matches(dyeOredict)) continue;
                DYE_CACHE.put(dyeOredict, dye);
                break;
            }
        }
        return DYE_CACHE.get(dyeOredict);
    }

    public static float[] average(float[] ... arrays) {
        int divisor = arrays.length;
        float[] output = new float[arrays[0].length];
        for (float[] array : arrays) {
            for (int j = 0; j < array.length; ++j) {
                int n = j;
                output[n] = output[n] + array[j];
            }
        }
        for (int i = 0; i < output.length; ++i) {
            output[i] = output[i] / (float)divisor;
        }
        return output;
    }

    @Nullable
    public static EnumDyeColor getColor(ItemStack stack) {
        if (stack != ItemStack.field_190927_a && BWOreDictionary.hasPrefix(stack, "dye")) {
            for (String ore : BWOreDictionary.getOres(stack)) {
                EnumDyeColor dye = ColorUtils.getDye(ore);
                if (dye == null) continue;
                return dye;
            }
        }
        return null;
    }

    public static float[] getColorFromBlock(World world, BlockPos pos, BlockPos beacon) {
        float[] fArray;
        if (world.func_175623_d(pos)) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        IBlockState state = world.func_180495_p(pos);
        float[] color = state.func_177230_c().getBeaconColorMultiplier(state, world, pos, beacon);
        if (color == null) {
            color = BlockColorProvider.INSTANCE.getColorComponents(BWMRecipes.getStackFromState(state));
        }
        if (color != null) {
            fArray = color;
        } else {
            float[] fArray2 = new float[3];
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray = fArray2;
            fArray2[2] = 1.0f;
        }
        return fArray;
    }

    public static int getDyeColor(EnumDyeColor color) {
        return (Integer)ReflectionHelper.getPrivateValue(EnumDyeColor.class, (Object)color, (String[])ReflectionLib.ENUMDYEECOLOR_COLORVALUE);
    }

    static {
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.DANDELION, new DyeAmount(EnumDyeColor.YELLOW, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.POPPY, new DyeAmount(EnumDyeColor.RED, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.BLUE_ORCHID, new DyeAmount(EnumDyeColor.LIGHT_BLUE, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.ALLIUM, new DyeAmount(EnumDyeColor.MAGENTA, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.HOUSTONIA, new DyeAmount(EnumDyeColor.SILVER, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.RED_TULIP, new DyeAmount(EnumDyeColor.RED, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.ORANGE_TULIP, new DyeAmount(EnumDyeColor.ORANGE, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.WHITE_TULIP, new DyeAmount(EnumDyeColor.SILVER, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.PINK_TULIP, new DyeAmount(EnumDyeColor.PINK, 2));
        ColorUtils.addFlower(BlockFlower.EnumFlowerType.OXEYE_DAISY, new DyeAmount(EnumDyeColor.SILVER, 2));
        ColorUtils.addFlower(BlockDoublePlant.EnumPlantType.PAEONIA, new DyeAmount(EnumDyeColor.PINK, 4));
        ColorUtils.addFlower(BlockDoublePlant.EnumPlantType.ROSE, new DyeAmount(EnumDyeColor.RED, 4));
        ColorUtils.addFlower(BlockDoublePlant.EnumPlantType.SYRINGA, new DyeAmount(EnumDyeColor.MAGENTA, 4));
        ColorUtils.addFlower(BlockDoublePlant.EnumPlantType.SUNFLOWER, new DyeAmount(EnumDyeColor.YELLOW, 4));
    }

    public static class DyeAmount {
        private EnumDyeColor dye;
        private int count;

        public DyeAmount(EnumDyeColor dye, int count) {
            this.dye = dye;
            this.count = count;
        }

        public ItemStack getStack() {
            return ColorUtils.getDye(this.dye, this.count);
        }
    }
}

