/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.crafting;

import betterwithmods.common.entity.EntityFallingGourd;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCMelon
extends Feature {
    @Override
    public String getFeatureDescription() {
        return "Makes Melons have gravity, makes for cool automation abilities";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Blocks.field_150394_bc.func_149711_c(0.2f);
        Blocks.field_150393_bb.func_149711_c(0.2f);
        Blocks.field_150440_ba.setHarvestLevel("axe", 1);
        Blocks.field_150423_aK.setHarvestLevel("axe", 1);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        Block block = event.getState().func_177230_c();
        if (block.equals(Blocks.field_150440_ba) || block.equals(Blocks.field_150423_aK)) {
            if (event.isSilkTouching() || event.getResult().equals((Object)Event.Result.DENY)) {
                return;
            }
            if (event.getDrops().removeIf(x -> x.func_77973_b().equals(Items.field_151127_ba))) {
                event.getDrops().add(new ItemStack(Blocks.field_150440_ba, 1));
            }
            if (!PlayerHelper.isCurrentToolEffectiveOnBlock(event.getHarvester(), event.getPos(), event.getState())) {
                event.getDrops().clear();
                if (block.equals(Blocks.field_150440_ba)) {
                    event.getDrops().add(new ItemStack(Items.field_151081_bc));
                } else {
                    event.getDrops().add(new ItemStack(Items.field_151080_bb));
                }
            }
        }
        if (block.equals(Blocks.field_150394_bc) || block.equals(Blocks.field_150393_bb)) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        this.makeGourdFall(world, event.getPos());
        this.makeGourdFall(world, event.getPos().func_177984_a());
    }

    private void makeGourdFall(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (block instanceof BlockMelon || block instanceof BlockPumpkin) {
            BlockPos bottompos = pos.func_177977_b();
            IBlockState bottomstate = world.func_180495_p(bottompos);
            if ((world.func_175623_d(bottompos) || BlockFalling.func_185759_i((IBlockState)bottomstate)) && !world.field_72995_K && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                EntityFallingGourd entitygourd = new EntityFallingGourd(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, blockstate);
                if (block instanceof BlockPumpkin) {
                    entitygourd.setSeedStack(new ItemStack(Items.field_151080_bb));
                } else {
                    entitygourd.setSeedStack(new ItemStack(Items.field_151081_bc));
                }
                world.func_72838_d((Entity)entitygourd);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

