/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRawPastry;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.Feature;
import betterwithmods.util.ColorUtils;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreIngredient;

public class MillRecipes
extends Feature {
    private boolean grindingOnly;

    public MillRecipes() {
        this.canDisable = false;
    }

    @Override
    public void setupConfig() {
        this.grindingOnly = this.loadPropBool("Grinding Only", "Remove normal recipes for certain grindable items", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (this.grindingOnly) {
            BWMRecipes.removeRecipe(new ItemStack(Items.field_151102_aT));
            BWMRecipes.removeRecipe(new ItemStack(Items.field_151065_br));
            BWMRecipes.removeRecipe(StackIngredient.fromStacks(new ItemStack(Items.field_185164_cV)));
            for (BlockIngredient flower : ColorUtils.FLOWER_TO_DYES.keySet()) {
                BWMRecipes.removeRecipe(flower);
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BWRegistry.MILLSTONE.addMillRecipe((Ingredient)new OreIngredient("netherrack"), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK)}), BWSounds.MILLSTONE_NETHERRACK);
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151072_bj), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151065_br, 3)}), SoundEvents.field_187600_C);
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(BWMBlocks.WOLF), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151007_F, 10), ColorUtils.getDye(EnumDyeColor.RED, 3)}), SoundEvents.field_187871_gL);
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151120_aE), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151102_aT, 2)}));
        BWRegistry.MILLSTONE.addMillRecipe((Ingredient)new OreIngredient("cropHemp"), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_FIBERS, 3));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151044_h, 1), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151044_h, 1, 1), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151103_aS), ColorUtils.getDye(EnumDyeColor.WHITE, 6));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151144_bL, 1, 0), ColorUtils.getDye(EnumDyeColor.WHITE, 10));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151144_bL, 1, 1), ColorUtils.getDye(EnumDyeColor.WHITE, 10));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Blocks.field_189880_di), ColorUtils.getDye(EnumDyeColor.WHITE, 9));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_185164_cV), ColorUtils.getDye(EnumDyeColor.RED, 2));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151116_aA), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER));
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_179555_bs), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER_CUT));
        BWRegistry.MILLSTONE.addMillRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_CUT), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER_CUT));
        for (BlockIngredient flower : ColorUtils.FLOWER_TO_DYES.keySet()) {
            BWRegistry.MILLSTONE.addMillRecipe((Ingredient)flower, ColorUtils.FLOWER_TO_DYES.get((Object)flower).getStack());
        }
        BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COCOA_POWDER));
        BWRegistry.MILLSTONE.addMillRecipe((Ingredient)new OreIngredient("cropWheat"), BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD));
        BWRegistry.MILLSTONE.addMillRecipe((Ingredient)new OreIngredient("cropBarley"), BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD));
        BWRegistry.MILLSTONE.addMillRecipe((Ingredient)new OreIngredient("cropOats"), BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD));
        BWRegistry.MILLSTONE.addMillRecipe((Ingredient)new OreIngredient("cropRye"), BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD));
        BWRegistry.MILLSTONE.addMillRecipe((Ingredient)new OreIngredient("cropRice"), BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD));
    }
}

