/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.gameplay.Gameplay;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="betterwithmods")
public class BlastingOilEvent {
    private static final HashMap<EntityItem, Double> highestPoint = Maps.newHashMap();

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingHurtEvent e) {
        IItemHandler inventory;
        if (Gameplay.disableBlastingOilEvents) {
            return;
        }
        if (e.getSource() == null || e.getSource().field_76373_n == null || Gameplay.blacklistDamageSources.contains(e.getSource().field_76373_n)) {
            return;
        }
        DamageSource BLAST_OIL = new DamageSource("blasting_oil");
        EntityLivingBase living = e.getEntityLiving();
        if (living.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (inventory = (IItemHandler)living.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            int count = 0;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b() || !stack.func_77969_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL))) continue;
                count += stack.func_190916_E();
                inventory.extractItem(i, stack.func_190916_E(), false);
            }
            if (count > 0) {
                living.func_70097_a(BLAST_OIL, Float.MAX_VALUE);
                living.func_130014_f_().func_72876_a(null, living.field_70165_t, living.field_70163_u + (double)(living.field_70131_O / 16.0f), living.field_70161_v, (float)(Math.sqrt(count / 5) / 2.5 + 1.0), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onHitGround(TickEvent.WorldTickEvent event) {
        List<EntityItem> items;
        if (Gameplay.disableBlastingOilEvents) {
            return;
        }
        World world = event.world;
        if (world.field_72995_K || event.phase != TickEvent.Phase.END) {
            return;
        }
        List list = world.field_72996_f;
        synchronized (list) {
            items = world.field_72996_f.stream().filter(e -> e instanceof EntityItem && ((EntityItem)e).func_92059_d().func_77969_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL))).map(e -> (EntityItem)e).collect(Collectors.toList());
        }
        HashSet toRemove = new HashSet();
        items.forEach(item -> {
            int count;
            boolean ground = item.field_70122_E;
            if ((item.func_70027_ad() || ground && Math.abs(item.field_70163_u - highestPoint.getOrDefault(item, item.field_70163_u)) > 2.0) && (count = item.func_92059_d().func_190916_E()) > 0) {
                world.func_72876_a((Entity)item, item.field_70165_t, item.field_70163_u + (double)(item.field_70131_O / 16.0f), item.field_70161_v, (float)(Math.sqrt(count / 5) / 2.5 + 1.0), true);
                toRemove.add(item);
                item.func_70106_y();
            }
            if (item.field_70181_x > 0.0 || !highestPoint.containsKey(item)) {
                highestPoint.put((EntityItem)item, item.field_70163_u);
            }
        });
        toRemove.forEach(highestPoint::remove);
    }
}

