/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityJungleSpider
extends EntityCaveSpider {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("betterwithmods", "entity/jungle_spider"));

    public EntityJungleSpider(World worldIn) {
        super(worldIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int duration = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected boolean func_70814_o() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, blockpos) <= 7;
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        BlockPos topPos = this.field_70170_p.func_175645_m(pos).func_177977_b();
        IBlockState topBlock = this.field_70170_p.func_180495_p(topPos);
        ArrayList<Integer> possible_spawns = this.getPossibleSpawnHeights(new BlockPos.MutableBlockPos(pos.func_177981_b(32)), 32);
        if (possible_spawns.isEmpty() && topBlock.func_177230_c() == Blocks.field_150362_t && ((Boolean)topBlock.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            possible_spawns = this.getPossibleSpawnHeights(new BlockPos.MutableBlockPos(topPos), 16);
        }
        if (possible_spawns.isEmpty()) {
            return false;
        }
        this.func_70107_b(this.field_70165_t, possible_spawns.get(this.field_70146_Z.nextInt(possible_spawns.size())).intValue(), this.field_70161_v);
        return super.func_70601_bi();
    }

    private ArrayList<Integer> getPossibleSpawnHeights(BlockPos.MutableBlockPos pos, int limit) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        int leaves = 0;
        for (int i = 0; i < limit; ++i) {
            IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
            leaves = this.isJungleLeaves(state) ? ++leaves : 0;
            if (leaves == 2) {
                heights.add(pos.func_177956_o() + 2);
            }
            pos.func_189536_c(EnumFacing.DOWN);
        }
        return heights;
    }

    private boolean isJungleLeaves(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150362_t && (Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a) != false;
    }
}

