/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class ConstructLibraryTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("betterwithmods", "construct_library");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        int bookcases = json.get("count").getAsInt();
        return new Instance(bookcases);
    }

    public void trigger(EntityPlayerMP player, int bookcases) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(bookcases);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(int bookcase) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(bookcase)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final int bookcases;

        public Instance(int bookcases) {
            super(ID);
            this.bookcases = bookcases;
        }

        public boolean test(int bookcases) {
            return bookcases >= this.bookcases;
        }
    }
}

