/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common;

import betterwithmods.api.util.IWood;
import betterwithmods.api.util.IWoodProvider;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockRawPastry;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.common.items.ItemBark;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.Wood;
import betterwithmods.util.InvUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class BWOreDictionary {
    public static List<ItemStack> cropNames;
    public static List<Ore> nuggetNames;
    public static List<Ore> dustNames;
    public static List<Ore> oreNames;
    public static List<Ore> ingotNames;
    public static List<IWood> woods;
    public static List<IWoodProvider> woodProviders;
    public static List<ItemStack> planks;
    public static List<ItemStack> logs;
    public static List<IRecipe> logRecipes;
    public static HashMultimap<String, String> toolEffectiveOre;

    public static void registerOres() {
        toolEffectiveOre.putAll((Object)"axe", (Iterable)Lists.newArrayList((Object[])new String[]{"logWood", "plankWood"}));
        toolEffectiveOre.putAll((Object)"mattock", (Iterable)Lists.newArrayList((Object[])new String[]{"stone", "cobblestone"}));
        BWOreDictionary.registerOre("wool", new ItemStack(Blocks.field_150325_L, Short.MAX_VALUE));
        BWOreDictionary.registerOre("scroll", BWMItems.ARCANE_SCROLL);
        BWOreDictionary.registerOre("book", BWMItems.MANUAL, Items.field_151122_aG, Items.field_151164_bB);
        BWOreDictionary.registerOre("dung", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        BWOreDictionary.registerOre("padding", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.PADDING));
        BWOreDictionary.registerOre("soap", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOAP));
        BWOreDictionary.registerOre("archimedesScrew", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCREW));
        BWOreDictionary.registerOre("filament", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.FILAMENT));
        BWOreDictionary.registerOre("latchRedstone", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.REDSTONE_LATCH));
        BWOreDictionary.registerOre("plateSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.PLATE_STEEL));
        BWOreDictionary.registerOre("arrowSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BROADHEAD));
        BWOreDictionary.registerOre("springSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_SPRING));
        BWOreDictionary.registerOre("gearSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_GEAR));
        BWOreDictionary.registerOre("gearWood", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR));
        BWOreDictionary.registerOre("cropHemp", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP));
        BWOreDictionary.registerOre("dyeBrown", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        BWOreDictionary.registerOre("dung", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        BWOreDictionary.registerOre("slimeball", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GLUE));
        BWOreDictionary.registerOre("glue", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GLUE));
        BWOreDictionary.registerOre("ingotSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));
        BWOreDictionary.registerOre("dustNetherrack", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK));
        BWOreDictionary.registerOre("dustHellfire", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST));
        BWOreDictionary.registerOre("dustSoul", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_DUST));
        BWOreDictionary.registerOre("dustWood", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_DUST));
        BWOreDictionary.registerOre("ingotConcentratedHellfire", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CONCENTRATED_HELLFIRE));
        BWOreDictionary.registerOre("dustCoal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST));
        BWOreDictionary.registerOre("dustPotash", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POTASH));
        BWOreDictionary.registerOre("dustWood", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST));
        BWOreDictionary.registerOre("dustSulfur", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE));
        BWOreDictionary.registerOre("dustSaltpeter", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NITER));
        BWOreDictionary.registerOre("nuggetSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NUGGET_STEEL));
        BWOreDictionary.registerOre("foodFlour", BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD));
        BWOreDictionary.registerOre("dustCharcoal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        BWOreDictionary.registerOre("foodCocoapowder", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COCOA_POWDER));
        BWOreDictionary.registerOre("dustCarbon", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        BWOreDictionary.registerOre("dustCoal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST));
        BWOreDictionary.registerOre("dustCharcoal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        BWOreDictionary.registerOre("gemNetherCoal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHERCOAL));
        BWOreDictionary.registerOre("materialNetherSludge", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHER_SLUDGE));
        BWOreDictionary.registerOre("foodChocolatebar", new ItemStack(BWMItems.CHOCOLATE));
        BWOreDictionary.registerOre("chainmail", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHAIN_MAIL));
        BWOreDictionary.registerOre("blockHardenedNetherClay", BlockAesthetic.getStack(BlockAesthetic.EnumType.NETHERCLAY));
        BWOreDictionary.registerOre("blockConcentratedHellfire", BlockAesthetic.getStack(BlockAesthetic.EnumType.HELLFIRE));
        BWOreDictionary.registerOre("blockPadding", BlockAesthetic.getStack(BlockAesthetic.EnumType.PADDING));
        BWOreDictionary.registerOre("blockEnder", BlockAesthetic.getStack(BlockAesthetic.EnumType.ENDERBLOCK));
        BWOreDictionary.registerOre("blockSoulforgedSteel", new ItemStack(BWMBlocks.STEEL_BLOCK, 1, 0));
        BWOreDictionary.registerOre("barkWood", new ItemStack(BWMItems.BARK, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("barkOak", new ItemStack(BWMItems.BARK, 1, 0));
        BWOreDictionary.registerOre("barkSpruce", new ItemStack(BWMItems.BARK, 1, 1));
        BWOreDictionary.registerOre("barkBirch", new ItemStack(BWMItems.BARK, 1, 2));
        BWOreDictionary.registerOre("barkJungle", new ItemStack(BWMItems.BARK, 1, 3));
        BWOreDictionary.registerOre("barkAcacia", new ItemStack(BWMItems.BARK, 1, 4));
        BWOreDictionary.registerOre("barkDarkOak", new ItemStack(BWMItems.BARK, 1, 5));
        BWOreDictionary.registerOre("barkBlood", new ItemStack(BWMItems.BARK, 1, 6));
        BWOreDictionary.registerOre("hideTanned", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TANNED_LEATHER));
        BWOreDictionary.registerOre("hideTanned", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TANNED_LEATHER_CUT));
        BWOreDictionary.registerOre("hideBelt", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_BELT));
        BWOreDictionary.registerOre("hideScoured", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER));
        BWOreDictionary.registerOre("hideStrap", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_STRAP));
        BWOreDictionary.registerOre("leather", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_CUT));
        BWOreDictionary.registerOre("fiberHemp", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_FIBERS));
        BWOreDictionary.registerOre("fabricHemp", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_CLOTH));
        BWOreDictionary.registerOre("ingotDiamond", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_INGOT));
        BWOreDictionary.registerOre("nuggetDiamond", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_NUGGET));
        BWOreDictionary.registerOre("listAllmeat", Items.field_151147_al, Items.field_151082_bd, Items.field_151076_bf, Items.field_151115_aP, Items.field_179561_bm, BWMItems.MYSTERY_MEAT);
        BWOreDictionary.registerOre("listAllmeat", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        BWOreDictionary.registerOre("listAllmeatcooked", Items.field_151157_am, Items.field_151083_be, Items.field_151077_bg, Items.field_179566_aV, Items.field_179557_bn, Items.field_179559_bp, BWMItems.COOKED_MYSTERY_MEAT);
        BWOreDictionary.registerOre("listAllmeatcooked", new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        BWOreDictionary.registerOre("foodStewMeat", Items.field_151157_am, Items.field_151083_be, Items.field_179566_aV, Items.field_179557_bn, BWMItems.COOKED_MYSTERY_MEAT);
        BWOreDictionary.registerOre("foodStewMeat", new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        BWOreDictionary.registerOre("tallow", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TALLOW));
        BWOreDictionary.registerOre("blockHellfire", new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.HELLFIRE.getMeta()));
        BWOreDictionary.registerOre("blockPlanter", new ItemStack(BWMBlocks.PLANTER, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("pile", new ItemStack(BWMItems.DIRT_PILE), new ItemStack(BWMItems.SAND_PILE), new ItemStack(BWMItems.RED_SAND_PILE), new ItemStack(BWMItems.GRAVEL_PILE));
        BWOreDictionary.registerOre("pileDirt", new ItemStack(BWMItems.DIRT_PILE));
        BWOreDictionary.registerOre("pileSand", new ItemStack(BWMItems.SAND_PILE), new ItemStack(BWMItems.RED_SAND_PILE));
        BWOreDictionary.registerOre("pileRedSand", new ItemStack(BWMItems.RED_SAND_PILE));
        BWOreDictionary.registerOre("pileGravel", new ItemStack(BWMItems.GRAVEL_PILE));
        BWOreDictionary.registerOre("blockVase", new ItemStack(BWMBlocks.VASE, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("blockUrn", new ItemStack(BWMBlocks.URN, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("treeSapling", new ItemStack(BWMBlocks.BLOOD_SAPLING));
        BWOreDictionary.registerOre("treeLeaves", new ItemStack(BWMBlocks.BLOOD_LEAVES));
        BWOreDictionary.registerOre("logWood", new ItemStack(BWMBlocks.BLOOD_LOG));
        BWOreDictionary.registerOre("blockNetherSludge", new ItemStack(BWMBlocks.NETHER_CLAY));
        BWOreDictionary.registerOre("cobblestone", new ItemStack(BWMBlocks.COBBLE, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("slats", new ItemStack(BWMBlocks.SLATS, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("grates", new ItemStack(BWMBlocks.GRATE, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("wicker", new ItemStack(BWMBlocks.WICKER));
        BWOreDictionary.registerOre("blockCandle", new ItemStack(BWMBlocks.CANDLE, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("stickWood", new ItemStack(BWMBlocks.SHAFT));
        BWOreDictionary.registerOre("blockWindChime", new ItemStack(BWMBlocks.BAMBOO_CHIME, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("blockWindChime", new ItemStack(BWMBlocks.METAL_CHIME, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("blockWoodTable", new ItemStack(BWMBlocks.WOOD_TABLE, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("blockWoodBench", new ItemStack(BWMBlocks.WOOD_BENCH, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("blockSoulUrn", BlockUrn.getStack(BlockUrn.EnumType.FULL, 1));
        BWOreDictionary.registerOre("dustBlaze", new ItemStack(Items.field_151065_br));
        BWOreDictionary.registerOre("foodDonut", BWMItems.DONUT);
        BWOreDictionary.registerOre("meatPork", Items.field_151147_al, Items.field_151157_am);
        BWOreDictionary.registerOre("meatBeef", Items.field_151082_bd, Items.field_151083_be);
        BWOreDictionary.registerOre("meatMutton", Items.field_179561_bm, Items.field_179557_bn);
        BWOreDictionary.registerOre("meatChicken", Items.field_151076_bf, Items.field_151077_bg);
        BWOreDictionary.registerOre("meatRotten", Items.field_151078_bh);
        BWOreDictionary.registerOre("meatFish", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.COD.func_150976_a()), new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        BWOreDictionary.registerOre("cookedPotato", Items.field_151168_bH);
        BWOreDictionary.registerOre("cookedCarrot", Items.field_151172_bF);
        BWOreDictionary.registerOre("listAllExplosives", new ItemStack(Blocks.field_150335_W));
        BWOreDictionary.registerOre("listAllExplosives", new ItemStack(Items.field_151016_H));
        BWOreDictionary.registerOre("listAllExplosives", new ItemStack(BWMItems.DYNAMITE));
        BWOreDictionary.registerOre("listAllExplosives", new ItemStack(BWMBlocks.MINING_CHARGE));
        BWOreDictionary.registerOre("listAllExplosives", BlockAesthetic.getStack(BlockAesthetic.EnumType.HELLFIRE));
        BWOreDictionary.registerOre("listAllExplosives", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL));
        BWOreDictionary.registerOre("listAllExplosives", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST));
        BWOreDictionary.registerOre("listAllExplosives", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CONCENTRATED_HELLFIRE));
        BWOreDictionary.registerOre("seed", new ItemStack(BWMBlocks.HEMP), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151081_bc), new ItemStack(Items.field_151080_bb), new ItemStack(Items.field_185163_cU));
        BWOreDictionary.registerOre("concrete", new ItemStack(Blocks.field_192443_dR, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("wool", new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("terracotta", Blocks.field_150406_ce, Blocks.field_192427_dB, Blocks.field_192428_dC, Blocks.field_192429_dD, Blocks.field_192430_dE, Blocks.field_192431_dF, Blocks.field_192432_dG, Blocks.field_192433_dH, Blocks.field_192434_dI, Blocks.field_192435_dJ, Blocks.field_192436_dK, Blocks.field_192437_dL, Blocks.field_192438_dM, Blocks.field_192439_dN, Blocks.field_192440_dO, Blocks.field_192441_dP, Blocks.field_192442_dQ);
    }

    private static ItemStack getPlankOutput(ItemStack log) {
        Iterator it = CraftingManager.field_193380_a.iterator();
        ItemStack stack = ItemStack.field_190927_a;
        block0: while (it.hasNext() && stack.func_190926_b()) {
            IRecipe recipe = (IRecipe)it.next();
            if (!BWOreDictionary.isPlank(recipe.func_77571_b())) continue;
            NonNullList ing = recipe.func_192400_c();
            for (Ingredient in : ing) {
                for (ItemStack check : in.func_193365_a()) {
                    if (!check.func_77969_a(log)) continue;
                    stack = recipe.func_77571_b().func_77946_l();
                    logRecipes.add(recipe);
                    break;
                }
                if (stack.func_190926_b()) continue;
                continue block0;
            }
        }
        return stack;
    }

    private static boolean isPlank(ItemStack output) {
        return BWOreDictionary.listContains(output, (List<ItemStack>)OreDictionary.getOres((String)"plankWood"));
    }

    public static void registerOre(String ore, ItemStack ... items) {
        for (ItemStack i : items) {
            OreDictionary.registerOre((String)ore, (ItemStack)i);
        }
    }

    public static void registerOre(String ore, Block ... blocks) {
        for (Block block : blocks) {
            BWOreDictionary.registerOre(ore, new ItemStack(block));
        }
    }

    public static void registerOre(String ore, Item ... items) {
        for (Item item : items) {
            BWOreDictionary.registerOre(ore, new ItemStack(item));
        }
    }

    public static void postInitOreDictGathering() {
        nuggetNames = BWOreDictionary.getOreIngredients("nugget");
        dustNames = BWOreDictionary.getOreIngredients("dust");
        oreNames = BWOreDictionary.getOreIngredients("ore");
        ingotNames = BWOreDictionary.getOreIngredients("ingot");
        cropNames = BWOreDictionary.getOreNames("crop");
        woods.addAll(Lists.newArrayList((Object[])new Wood[]{new Wood(new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack(Blocks.field_150344_f, 1, 0), ItemBark.getStack("oak", 1)), new Wood(new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Blocks.field_150344_f, 1, 1), ItemBark.getStack("spruce", 1)), new Wood(new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Blocks.field_150344_f, 1, 2), ItemBark.getStack("birch", 1)), new Wood(new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Blocks.field_150344_f, 1, 3), ItemBark.getStack("jungle", 1)), new Wood(new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack(Blocks.field_150344_f, 1, 4), ItemBark.getStack("acacia", 1)), new Wood(new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack(Blocks.field_150344_f, 1, 5), ItemBark.getStack("dark_oak", 1)), new Wood(new ItemStack(BWMBlocks.BLOOD_LOG), new ItemStack(Blocks.field_150344_f, 1, 3), ItemBark.getStack("bloody", 1), true)}));
        woods.forEach(w -> BWOreDictionary.getPlankOutput(w.getLog(1)));
        logs = OreDictionary.getOres((String)"logWood").stream().filter(stack -> !stack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("minecraft") && !stack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("betterwithmods")).collect(Collectors.toList());
        for (ItemStack log : logs) {
            if (log.func_77960_j() == Short.MAX_VALUE) {
                for (int i = 0; i <= 4; ++i) {
                    ItemStack subLog = new ItemStack(log.func_77973_b(), 1, i);
                    ItemStack plank = BWOreDictionary.getPlankOutput(subLog);
                    if (plank.func_190926_b() || BWOreDictionary.isWoodRegistered(subLog)) continue;
                    Wood wood = new Wood(subLog, plank);
                    woods.add(wood);
                }
                continue;
            }
            ItemStack plank = BWOreDictionary.getPlankOutput(log);
            if (plank.func_190926_b() || BWOreDictionary.isWoodRegistered(log)) continue;
            Wood wood = new Wood(log, plank);
            woods.add(wood);
        }
    }

    public static boolean isWoodRegistered(ItemStack stack) {
        return woods.stream().anyMatch(wood -> wood.getLog(1).func_77969_a(stack));
    }

    public static List<ItemStack> getOreNames(String prefix) {
        return Arrays.stream(OreDictionary.getOreNames()).filter(Objects::nonNull).filter(n -> n.startsWith(prefix)).map(OreDictionary::getOres).filter(o -> !o.isEmpty()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<ItemStack> getItems(List<Ore> ores) {
        return ores.stream().flatMap(o -> o.getOres().stream()).collect(Collectors.toList());
    }

    public static List<Ore> getOreIngredients(String prefix) {
        return Arrays.stream(OreDictionary.getOreNames()).filter(Objects::nonNull).filter(n -> n.startsWith(prefix)).map(n -> new Ore(prefix, (String)n)).collect(Collectors.toList());
    }

    public static int listContains(Object obj, List<Object> list) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack toCheck;
                ItemStack stack;
                if (!(obj instanceof ItemStack) || !(list.get(i) instanceof ItemStack) || !ItemStack.func_179545_c((ItemStack)(stack = (ItemStack)obj), (ItemStack)(toCheck = (ItemStack)list.get(i)))) continue;
                if (toCheck.func_77942_o()) {
                    if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)toCheck)) continue;
                    return i;
                }
                if (stack.func_77942_o()) {
                    return -1;
                }
                return i;
            }
        }
        return -1;
    }

    public static boolean isOre(ItemStack stack, String ore) {
        return BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)ore));
    }

    public static boolean listContains(ItemStack check, List<ItemStack> list) {
        if (list != null) {
            if (list.isEmpty()) {
                return false;
            }
            for (ItemStack item : list) {
                if (!ItemStack.func_179545_c((ItemStack)check, (ItemStack)item) && (check.func_77973_b() != item.func_77973_b() || item.func_77952_i() != Short.MAX_VALUE)) continue;
                return !item.func_77942_o() || ItemStack.func_77970_a((ItemStack)check, (ItemStack)item);
            }
        }
        return false;
    }

    public static List<String> getOres(ItemStack stack) {
        return IntStream.of(OreDictionary.getOreIDs((ItemStack)stack)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList());
    }

    public static boolean hasPrefix(ItemStack stack, String suffix) {
        return BWOreDictionary.listContains(stack, BWOreDictionary.getOreNames(suffix));
    }

    public static boolean isToolForOre(String tool, ItemStack stack) {
        return toolEffectiveOre.get((Object)tool).stream().anyMatch(BWOreDictionary.getOres(stack)::contains);
    }

    public static IWood getWoodFromState(IBlockState state) {
        ItemStack stack = BWMRecipes.getStackFromState(state);
        IWood wood = null;
        if (!stack.func_190926_b()) {
            wood = woods.stream().filter(w -> InvUtils.matches(w.getLog(1), stack)).findFirst().orElse(null);
        }
        if (wood == null) {
            for (IWoodProvider provider : woodProviders) {
                if (!provider.match(state)) continue;
                wood = provider.getWood(state);
                break;
            }
        }
        return wood;
    }

    public static List<Ingredient> fromOres(String ... ores) {
        return Arrays.stream(ores).map(OreIngredient::new).collect(Collectors.toList());
    }

    static {
        woods = new ArrayList<IWood>();
        woodProviders = new ArrayList<IWoodProvider>();
        logRecipes = new ArrayList<IRecipe>();
        toolEffectiveOre = HashMultimap.create();
    }

    public static class Ore
    extends OreIngredient {
        private String prefix;
        private String ore;

        public Ore(String prefix, String ore) {
            super(ore);
            this.prefix = prefix;
            this.ore = ore;
        }

        public List<ItemStack> getOres() {
            return OreDictionary.getOres((String)this.ore);
        }

        public String getOre() {
            return this.ore;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.ore.substring(this.getPrefix().length());
        }
    }
}

