/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.model.render;

import betterwithmods.client.model.render.RenderUtils;
import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public abstract class PixelOperationSprite
extends TextureAtlasSprite {
    private final ResourceLocation location;

    protected PixelOperationSprite(String entry, ResourceLocation location) {
        super(entry);
        this.location = location;
    }

    public abstract int apply(int var1, int var2, int var3);

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation loc, Function<ResourceLocation, TextureAtlasSprite> getter) {
        BufferedImage image = RenderUtils.getTextureImage(this.location);
        if (image == null) {
            return false;
        }
        this.func_110966_b(image.getWidth());
        this.func_110969_c(image.getHeight());
        int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
        pixels[0] = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
        for (int i = 0; i < pixels[0].length; ++i) {
            pixels[0][i] = this.apply(i % image.getWidth(), i / image.getWidth(), pixels[0][i]);
        }
        this.func_130103_l();
        this.field_110976_a.add(pixels);
        return false;
    }

    public static class Multiply
    extends PixelOperationSprite {
        private final int color;

        public Multiply(String entry, ResourceLocation location, int color) {
            super(entry, location);
            this.color = color;
        }

        @Override
        public int apply(int x, int y, int value) {
            return RenderUtils.multiplyColor(value, this.color);
        }
    }
}

