/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.InventoryChangeTriggerExtended;
import com.bloodnbonesgaming.triumph.config.data.MinMaxBoundsData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/inventory_changed", classExplaination="These are the functions which can be called on a minecraft:inventory_changed criteria trigger.")
public class InventoryChangeTriggerData
extends CriterionTriggerData {
    private MinMaxBoundsData occupied = new MinMaxBoundsData();
    private MinMaxBoundsData full = new MinMaxBoundsData();
    private MinMaxBoundsData empty = new MinMaxBoundsData();
    Map<ItemPredicate, MinMaxBounds> itemPredicateList = new HashMap<ItemPredicate, MinMaxBounds>();
    private List<ItemBlockData> itemDataList = new ArrayList<ItemBlockData>();

    public InventoryChangeTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        return new Criterion((ICriterionInstance)new InventoryChangeTriggerExtended(this.occupied.buildBounds(), this.full.buildBounds(), this.empty.buildBounds(), this.buildItemPredicateArray()));
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max values for occupied inventory slots.")
    public void setOccupiedMinMax(float min, float max) {
        this.occupied.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min value for occupied inventory slots.")
    public void setOccupiedMin(float min) {
        this.occupied.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max value for occupied inventory slots.")
    public void setOccupiedMax(float max) {
        this.occupied.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max values for full inventory slots.")
    public void setFullMinMax(float min, float max) {
        this.occupied.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min value for full inventory slots.")
    public void setFullMin(float min) {
        this.occupied.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max value for full inventory slots.")
    public void setFullMax(float max) {
        this.occupied.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max values for empty inventory slots.")
    public void setEmptyMinMax(float min, float max) {
        this.occupied.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min value for empty inventory slots.")
    public void setEmptyMin(float min) {
        this.occupied.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max value for empty inventory slots.")
    public void setEmptyMax(float max) {
        this.occupied.setMax(max);
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Adds a required item.")
    public void addItem(ItemBlockData data) throws Exception {
        MinMaxBounds count = data.count;
        data.setCount(MinMaxBounds.field_192516_a);
        this.itemPredicateList.put(data.buildItemPredicate(), count);
    }

    public Map<ItemPredicate, MinMaxBounds> buildItemPredicateArray() throws Exception {
        HashMap<ItemPredicate, MinMaxBounds> map = new HashMap<ItemPredicate, MinMaxBounds>();
        for (ItemBlockData data : this.itemDataList) {
            MinMaxBounds count = data.count;
            data.setCount(MinMaxBounds.field_192516_a);
            map.put(data.buildItemPredicate(), count);
        }
        map.putAll(this.itemPredicateList);
        return map;
    }

    public ItemBlockData addItem() {
        ItemBlockData data = new ItemBlockData();
        this.itemDataList.add(data);
        return data;
    }

    public ItemBlockData addItem(String itemName) {
        return this.addItem(itemName, null);
    }

    public ItemBlockData addItem(String itemName, Integer meta) {
        ItemBlockData data = new ItemBlockData();
        this.itemDataList.add(data);
        data.setLocation(itemName);
        data.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
        return data;
    }

    public ItemBlockData addItem(String itemName, Integer meta, String nbt) throws Exception {
        ItemBlockData data = new ItemBlockData();
        this.itemDataList.add(data);
        data.setLocation(itemName);
        data.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
        data.setNBT(nbt);
        return data;
    }

    public ItemBlockData addOreDict(String oreDict) throws Exception {
        ItemBlockData data = new ItemBlockData();
        this.itemDataList.add(data);
        data.setOre(oreDict);
        return data;
    }

    public ItemBlockData setItem() {
        return this.addItem();
    }

    public ItemBlockData setItem(String itemName) {
        return this.addItem(itemName);
    }

    public ItemBlockData setItem(String itemName, Integer meta) {
        return this.addItem(itemName, meta);
    }
}

