/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.tile;

import com.valkyrieofnight.sg.m_generators.gui.GuiGenBase;
import com.valkyrieofnight.sg.m_generators.inventory.ContainerGenBase;
import com.valkyrieofnight.um.api.attribute.GenericAttributes;
import com.valkyrieofnight.um.api.inventory.ItemHandlerModifiable;
import com.valkyrieofnight.um.api.modifier.IModifier;
import com.valkyrieofnight.um.modifier.ModifierHandler;
import com.valkyrieofnight.vliblegacy.lib.client.handler.IGuiHandlingObject;
import com.valkyrieofnight.vliblegacy.lib.inventory.VLItemHandlerLimited;
import com.valkyrieofnight.vliblegacy.lib.sys.tile.tocker.IGeneratorTicker;
import com.valkyrieofnight.vliblegacy.lib.sys.tile.tocker.TockTracker;
import com.valkyrieofnight.vliblegacy.lib.tile.energy.VLTileEnergyProducer;
import com.valkyrieofnight.vliblegacy.lib.tilemodule.energyu.fe.ForgeEnergyUtil;
import com.valkyrieofnight.vliblegacy.lib.tilemodule.energyu.fe.IFEProducer;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileGenBase
extends VLTileEnergyProducer
implements IGeneratorTicker,
IGuiHandlingObject {
    protected TockTracker progress = new TockTracker();
    protected ItemHandlerModifiable modifierSlots;
    protected ModifierHandler modifierHandler;
    protected VLItemHandlerLimited input;
    protected VLItemHandlerLimited output;
    protected int duration;
    protected int rfTotal;
    int pmtick = 0;

    public TileGenBase(int capacity, int upgradeSlots, boolean output) {
        super(capacity, capacity);
        this.modifierSlots = new ItemHandlerModifiable(upgradeSlots);
        this.modifierHandler = new ModifierHandler();
        this.input = new VLItemHandlerLimited(){

            public boolean isValidInput(ItemStack stack) {
                return TileGenBase.this.isValidInputStack(stack);
            }
        };
        this.input.setIO(true, true);
        int outs = 0;
        if (output) {
            outs = 1;
        }
        this.output = new VLItemHandlerLimited(outs){

            public boolean isValidInput(ItemStack stack) {
                return true;
            }
        };
    }

    protected abstract boolean isValidInputStack(ItemStack var1);

    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        this.progress.writeToNBT(nbt);
        nbt.func_74782_a("modifiers", (NBTBase)this.modifierSlots.serializeNBT());
        nbt.func_74782_a("input", (NBTBase)this.input.serializeNBT());
        nbt.func_74768_a("fduration", this.duration);
        nbt.func_74768_a("frftotal", this.rfTotal);
        return nbt;
    }

    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        this.progress.readFromNBT(nbt);
        this.modifierSlots.deserializeNBT(nbt.func_74775_l("modifiers"));
        this.input.deserializeNBT(nbt.func_74775_l("input"));
        this.duration = nbt.func_74762_e("fduration");
        this.rfTotal = nbt.func_74762_e("frftotal");
    }

    public boolean canSaveOnPickup() {
        return true;
    }

    public void writeClientDataToNBT(NBTTagCompound nbt) {
        this.eBuffer.writeToNBT(nbt);
        this.progress.writeToNBT(nbt);
        nbt.func_74768_a("fduration", this.duration);
        nbt.func_74768_a("frftotal", this.rfTotal);
    }

    public void readClientDataFromNBT(NBTTagCompound nbt) {
        this.eBuffer.readFromNBT(nbt);
        this.progress.readFromNBT(nbt);
        this.duration = nbt.func_74762_e("fduration");
        this.rfTotal = nbt.func_74762_e("frftotal");
        this.modifierSlots.setChanged();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.input;
            }
            switch (facing) {
                case DOWN: {
                    return (T)this.output;
                }
            }
            return (T)this.input;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ItemHandlerModifiable getModifierSlots() {
        return this.modifierSlots;
    }

    public VLItemHandlerLimited getInputSlots() {
        return this.input;
    }

    public VLItemHandlerLimited getOutputSlots() {
        return this.output;
    }

    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            ++this.pmtick;
            this.modifierHandler.update();
            if (this.modifierSlots.hasChanged() || this.pmtick > 60) {
                this.processModifiers();
                this.pmtick = 0;
            }
            this.updateTicker();
            ForgeEnergyUtil.sendEnergyToFirst((World)this.getTheWorld(), (BlockPos)this.field_174879_c, (IFEProducer)this.eBuffer, (EnumFacing[])this.validConectionDirections());
        }
    }

    public void processModifiers() {
        ArrayList<IModifier> mods = new ArrayList<IModifier>();
        NonNullList slotsL = this.modifierSlots.getStacks();
        int ts = this.modifierSlots.getSlots();
        for (int i = 0; i < slotsL.size(); ++i) {
            ItemStack is;
            if (i < 0 || i > ts || (is = (ItemStack)slotsL.get(i)) == ItemStack.field_190927_a) continue;
            if (Block.func_149634_a((Item)is.func_77973_b()) instanceof IModifier) {
                for (int j = 0; j < is.func_190916_E(); ++j) {
                    mods.add((IModifier)Block.func_149634_a((Item)is.func_77973_b()));
                }
                continue;
            }
            if (!(is.func_77973_b() instanceof IModifier)) continue;
            for (int k = 0; k < is.func_190916_E(); ++k) {
                mods.add((IModifier)is.func_77973_b());
            }
        }
        this.modifierHandler.setModifiers(mods);
        this.modifierHandler.update();
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerGenBase(player.field_71071_by, this);
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGenBase(player, new ContainerGenBase(player.field_71071_by, this), this);
    }

    public TockTracker getTracker() {
        return this.progress;
    }

    public World getTheWorld() {
        return this.field_145850_b;
    }

    public void onComplete() {
        this.eBuffer.iReceiveFE(this.getEnergyRemainder(), false);
    }

    public int getTickTocks() {
        if (this.modifierHandler.hasAttribute(GenericAttributes.TICK_SPEED)) {
            int tocks = (Integer)GenericAttributes.TICK_SPEED.getCalculator().calculateModifiedValue(this.modifierHandler.getAttributeFinalValue(GenericAttributes.TICK_SPEED), (Object)1);
            return tocks;
        }
        return 1;
    }

    public int checkEnergyStorage(int tocks) {
        if (this.getEnergyPerTock() <= 0 && this.getEnergyRemainder() <= 0) {
            return 0;
        }
        int energyRoom = this.eBuffer.getEnergyRoom();
        int ept = this.getEnergyPerTock();
        if (ept < 1) {
            return 0;
        }
        int tt = energyRoom / ept;
        return Math.min(tt, tocks);
    }

    protected int getEnergyPerTock() {
        if (this.duration <= 0) {
            return 0;
        }
        return this.rfTotal / this.duration;
    }

    protected int getEnergyRemainder() {
        if (this.duration <= 0) {
            return 0;
        }
        return this.rfTotal % this.duration;
    }

    public String calculateTimeLeft() {
        String hour;
        int ttocks = this.getTickTocks();
        int ticks = this.progress.getTocksRemaining() / Math.max(ttocks, 1);
        int totalSecs = ticks / 20;
        int tdays = totalSecs / 86400;
        int hours = totalSecs / 3600;
        int minutes = totalSecs % 3600 / 60;
        int seconds = totalSecs % 60;
        String secs = seconds < 10 ? "0" + seconds : seconds + "";
        String mins = minutes < 10 ? "0" + minutes : minutes + "";
        String string = hour = hours < 10 ? "0" + hours : hours + "";
        String days = tdays < 100 ? "0" + tdays : (tdays < 10 ? "00" + tdays : tdays + "");
        return (tdays > 0 ? days + ":" : "") + (hours > 0 ? hour + ":" : "") + (minutes > 0 ? mins + ":" : "") + secs;
    }

    public int getTockDurationFromResource() {
        return this.duration;
    }

    public void onProcessTocks(int tocks) {
        this.processTocks(tocks);
        this.eBuffer.iReceiveFE(this.getEnergyPerTock() * tocks, false);
        this.markForUpdate();
    }

    protected abstract void processTocks(int var1);

    public float getEnergyLevelScale() {
        return (float)this.eBuffer.getEnergyStored() / (float)this.eBuffer.getMaxEnergyStored();
    }

    public float getFuelBufferScale() {
        if (this.progress.getTocksTotal() <= 0) {
            return 1.0f;
        }
        return (float)this.progress.getTocksComplete() / (float)this.progress.getTocksTotal();
    }

    public abstract EnumFacing[] validConectionDirections();
}

