/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMetaVariants;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.decoration.feature.TallowAndCandles;

public class BlockCandle
extends BlockMetaVariants<Variants>
implements IQuarkBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625);

    public BlockCandle() {
        super("candle", Material.field_151571_B, Variants.class);
        this.func_149711_c(0.2f);
        this.func_149715_a(0.9375f);
        this.func_149713_g(0);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && TallowAndCandles.candlesFall) {
            this.checkFallable(worldIn, pos);
        }
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return TallowAndCandles.enchantPower;
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos blockPos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    public static enum Variants implements IStringSerializable
    {
        CANDLE_WHITE,
        CANDLE_ORANGE,
        CANDLE_MAGENTA,
        CANDLE_LIGHT_BLUE,
        CANDLE_YELLOW,
        CANDLE_LIME,
        CANDLE_PINK,
        CANDLE_GRAY,
        CANDLE_SILVER,
        CANDLE_CYAN,
        CANDLE_PURPLE,
        CANDLE_BLUE,
        CANDLE_BROWN,
        CANDLE_GREEN,
        CANDLE_RED,
        CANDLE_BLACK;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

