/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.network;

import com.gendeathrow.mputils.client.gui.ScreenNotification;
import com.gendeathrow.mputils.core.MPUtils;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class ScreenNotificationPacket
implements IMessage {
    private int count;
    private List<String> lines = new ArrayList<String>();
    private String soundFile;
    private int bgColor = Color.GRAY.getRGB();
    private int borderColor = Color.BLACK.getRGB();

    public ScreenNotificationPacket() {
    }

    public ScreenNotificationPacket(List<String> lines) {
        this(lines, SoundEvents.field_187802_ec.getRegistryName().toString());
    }

    public ScreenNotificationPacket(List<String> linesIn, String sound) {
        this(linesIn, sound, Color.GRAY.getRGB(), Color.BLACK.getRGB());
    }

    public ScreenNotificationPacket(List<String> linesIn, String sound, int bgcolorIn, int bordercolorIn) {
        this.lines = linesIn;
        this.count = linesIn.size();
        this.soundFile = sound;
        this.bgColor = bgcolorIn;
        this.borderColor = bordercolorIn;
    }

    public void fromBytes(ByteBuf buf) {
        this.lines.clear();
        this.soundFile = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.bgColor = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.borderColor = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.count = ByteBufUtils.readVarShort((ByteBuf)buf);
        for (int i = 0; i < this.count; ++i) {
            this.lines.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.soundFile == null ? "null" : this.soundFile));
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.bgColor, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.borderColor, (int)5);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.lines.size());
        for (String line : this.lines) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)line);
        }
    }

    public static class ClientHandler
    implements IMessageHandler<ScreenNotificationPacket, IMessage> {
        public IMessage onMessage(final ScreenNotificationPacket message, MessageContext ctx) {
            if (message == null || message.lines.isEmpty()) {
                MPUtils.logger.log(Level.ERROR, "A critical NPE error occured during while handling a MPUtils notification packet Client side", (Throwable)new NullPointerException());
                return null;
            }
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ScreenNotification.ScheduleNotice(message.lines, message.soundFile.equals("null") ? null : message.soundFile, message.bgColor, message.borderColor);
                }
            });
            return null;
        }
    }
}

