/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevtweaks.common.gamestages;

import java.util.Collection;
import java.util.Objects;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import tv.darkosto.sevtweaks.SevTweaks;
import tv.darkosto.sevtweaks.common.config.Configuration;

public class GameStageScoreboard {
    private static final String OBJECTIVE_NAME = "ST_Stage";
    private static final String OBJECTIVE_TITLE = "Players Stage";

    private static void setStageScore(EntityPlayer player, int stageValue) {
        WorldServer world = Objects.requireNonNull(player.field_70170_p.func_73046_m()).func_71218_a(0);
        Scoreboard scoreboard = world.func_96441_U();
        ScoreObjective objective = scoreboard.func_96518_b(OBJECTIVE_NAME);
        if (objective == null) {
            SevTweaks.logger.debug(String.format("World does not have the objective %s", OBJECTIVE_NAME));
            return;
        }
        if (stageValue <= 0) {
            scoreboard.func_178822_d(player.func_70005_c_(), objective);
        } else {
            Score score = scoreboard.func_96529_a(player.func_70005_c_(), objective);
            score.func_96647_c(stageValue);
        }
    }

    private static Collection<String> getPlayerStages(EntityPlayer player) {
        IStageData stageData = GameStageHelper.getPlayerData((EntityPlayer)player);
        return stageData.getStages();
    }

    private static void handlePlayerStage(EntityPlayer player, String stageFromEvent) {
        if (!Stages.contains(stageFromEvent)) {
            SevTweaks.logger.debug("Stage {} is not a valid stage for the modpack.", (Object)stageFromEvent);
        }
        Collection<String> stages = GameStageScoreboard.getPlayerStages(player);
        Stages highestStage = GameStageScoreboard.getHighestStage(stages);
        GameStageScoreboard.setStageScore(player, highestStage.ordinal() - 1);
    }

    private static Stages getHighestStage(Collection<String> playerStages) {
        Stages[] stages = Stages.values();
        ArrayUtils.reverse((Object[])stages);
        for (Stages s : stages) {
            if (!playerStages.contains(s.name().toLowerCase())) continue;
            return s;
        }
        return Stages.TUTORIAL;
    }

    @SubscribeEvent
    public static void onStageAdded(GameStageEvent.Added stageEvent) {
        GameStageScoreboard.handlePlayerStage(stageEvent.getEntityPlayer(), stageEvent.getStageName());
    }

    @SubscribeEvent
    public static void onStageRemoved(GameStageEvent.Removed stageEvent) {
        GameStageScoreboard.handlePlayerStage(stageEvent.getEntityPlayer(), stageEvent.getStageName());
    }

    @SubscribeEvent
    public static void onStageCleared(GameStageEvent.Cleared clearedEvent) {
        GameStageScoreboard.setStageScore(clearedEvent.getEntityPlayer(), 0);
    }

    public boolean init(MinecraftServer server) {
        Scoreboard scoreboard = server.func_71218_a(0).func_96441_U();
        if (scoreboard.func_96518_b(OBJECTIVE_NAME) != null) {
            return false;
        }
        ScoreObjective objective = scoreboard.func_96535_a(OBJECTIVE_NAME, IScoreCriteria.field_96641_b);
        objective.func_96681_a(OBJECTIVE_TITLE);
        scoreboard.func_96530_a(this.validatePosition(), objective);
        return true;
    }

    private int validatePosition() {
        int configPosition = Configuration.gamestageScoreboard.scoreboardPosition;
        if (configPosition < 0 || configPosition > 2) {
            return 2;
        }
        return configPosition;
    }

    public void syncPlayers(MinecraftServer server) {
        WorldServer world = server.func_71218_a(0);
        Scoreboard scoreboard = world.func_96441_U();
        ScoreObjective objective = scoreboard.func_96518_b(OBJECTIVE_NAME);
        if (objective == null) {
            return;
        }
        PlayerList playerList = server.func_184103_al();
        for (EntityPlayerMP playerMP : playerList.func_181057_v()) {
            Collection<String> stages = GameStageScoreboard.getPlayerStages((EntityPlayer)playerMP);
            Stages highestStage = GameStageScoreboard.getHighestStage(stages);
            if (highestStage == Stages.TUTORIAL) continue;
            GameStageScoreboard.setStageScore((EntityPlayer)playerMP, highestStage.ordinal() - 1);
        }
    }

    private static enum Stages {
        TUTORIAL,
        ZERO,
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        CREATIVE;


        public static boolean contains(String stage) {
            for (Stages s : Stages.values()) {
                if (!s.name().equals(stage)) continue;
                return true;
            }
            return false;
        }
    }
}

