/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.feature.plants;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import nmd.primal.core.common.blocks.plants.AbstractPlant;

public class GenGrass
extends WorldGenerator {
    private final Predicate<IBlockState> blacklist;
    private IBlockState plateState;
    private AbstractPlant plantBlock;
    private int iterations;

    public GenGrass(int iterations, IBlockState state, Predicate<IBlockState> blacklist) {
        this.blacklist = blacklist;
        this.plateState = state;
        this.plantBlock = (AbstractPlant)state.func_177230_c();
        this.iterations = iterations;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        IBlockState iblockstate = world.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)world, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)world, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = world.func_180495_p(position);
        }
        for (int i = 0; i < this.iterations; ++i) {
            BlockPos gen_pos = position.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            IBlockState gen_on = world.func_180495_p(gen_pos.func_177977_b());
            if (!world.func_175623_d(gen_pos) || this.blacklist.apply((Object)gen_on) || !this.plantBlock.canBlockStay(world, gen_pos, this.plateState)) continue;
            world.func_180501_a(gen_pos, this.plateState, 18);
        }
        return true;
    }

    static class EmptyPredicate
    implements Predicate<IBlockState> {
        private EmptyPredicate() {
        }

        public boolean apply(IBlockState state) {
            return false;
        }
    }
}

