/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.feature;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.types.IQuality;
import nmd.primal.core.common.helper.checks.BlockMultiplexer;

public class GenOreNearWater
extends WorldGenerator {
    private final Predicate<IBlockState> predicate;
    private final IBlockState oreBlock;
    private final int numberOfBlocks;

    public GenOreNearWater(IBlockState state, int blockCount, Predicate<IBlockState> predicate) {
        this.oreBlock = state;
        this.numberOfBlocks = blockCount;
        this.predicate = predicate;
    }

    public GenOreNearWater(int blockCount) {
        this(PrimalAPI.Blocks.SATETSU.func_176223_P(), blockCount, BlockMultiplexer.forBlock(new Block[]{Blocks.field_150354_m, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150349_c}));
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        for (int n = 0; n < 36; ++n) {
            BlockPos pos_check_on;
            BlockPos pos_check = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), 0, rand.nextInt(4) - rand.nextInt(4));
            if (!world.func_175623_d(pos_check) || world.func_180495_p((pos_check_on = pos_check.func_177977_b()).func_177976_e()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos_check_on.func_177974_f()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos_check_on.func_177978_c()).func_185904_a() != Material.field_151586_h && world.func_180495_p(pos_check_on.func_177968_d()).func_185904_a() != Material.field_151586_h) continue;
            PrimalAPI.logger(2, "worldgen", this.oreBlock.func_177230_c().func_149739_a() + "@" + pos + ", found water");
            float f = rand.nextFloat() * (float)Math.PI;
            double d0 = (float)(pos.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d1 = (float)(pos.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d2 = (float)(pos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d3 = (float)(pos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
            double d4 = pos.func_177956_o() + rand.nextInt(3) - 2;
            double d5 = pos.func_177956_o() + rand.nextInt(3) - 2;
            int quality = 0;
            boolean count_down = false;
            for (int i = 0; i < this.numberOfBlocks; ++i) {
                float f1 = (float)i / (float)this.numberOfBlocks;
                double d6 = d0 + (d1 - d0) * (double)f1;
                double d7 = d4 + (d5 - d4) * (double)f1;
                double d8 = d2 + (d3 - d2) * (double)f1;
                double d9 = rand.nextDouble() * (double)this.numberOfBlocks / 16.0;
                double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
                double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
                int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
                int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
                int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
                int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
                int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
                int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
                for (int l1 = j; l1 <= i1; ++l1) {
                    double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                    if (!(d12 * d12 < 1.0)) continue;
                    for (int i2 = k; i2 <= j1; ++i2) {
                        double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                        if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                        for (int j2 = l; j2 <= k1; ++j2) {
                            BlockPos blockpos;
                            IBlockState state;
                            double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                            if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !(state = world.func_180495_p(blockpos = new BlockPos(l1, i2, j2))).func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, blockpos, this.predicate)) continue;
                            world.func_180501_a(blockpos, this.oreBlock.func_177226_a(IQuality.QUALITY, (Comparable)((Object)IQuality.EnumQuality.byMetadata(quality))), 18);
                            if (count_down) {
                                if (quality > 0 && PrimalAPI.randomCheck(8)) {
                                    --quality;
                                    continue;
                                }
                                if (quality != 0) continue;
                                count_down = false;
                                continue;
                            }
                            if (quality < 4 && PrimalAPI.randomCheck(8)) {
                                ++quality;
                                continue;
                            }
                            if (quality != 4 || !PrimalAPI.randomCheck(16)) continue;
                            count_down = true;
                        }
                    }
                }
            }
        }
        return true;
    }
}

