/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.interfaces.crafting.ICatalyst;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.helper.StackHelper;
import nmd.primal.core.common.recipes.AbstractRecipe;
import nmd.primal.core.common.tiles.machines.TileCauldron;

public class CauldronRecipe
extends AbstractRecipe<CauldronRecipe>
implements ICatalyst<CauldronRecipe> {
    public static final String RECIPE_PREFIX = "cauldron";
    public static final IForgeRegistry<CauldronRecipe> REGISTRY = GameRegistry.findRegistry(CauldronRecipe.class);
    public static final Collection<CauldronRecipe> RECIPES = REGISTRY.getValuesCollection();
    private final FluidStack fluid_input;
    private final FluidStack fluid_output;
    private final List<List<ItemStack>> item_input = new ArrayList<List<ItemStack>>(4);
    private final List<ItemStack> item_output = new ArrayList<ItemStack>(2);
    private ItemStack bottle;
    private ItemStack bucket;
    private ItemStack catalyst;
    private final int cook_time;
    private int catalyst_slot;
    private boolean require_lid;

    public CauldronRecipe(int cook_time, FluidStack fluid_input, FluidStack fluid_output, List<ItemStack> item_input_1, List<ItemStack> item_input_2, List<ItemStack> item_input_3, List<ItemStack> item_input_4, ItemStack item_output_1, ItemStack item_output_2) {
        this.fluid_input = fluid_input;
        this.fluid_output = fluid_output;
        RecipeHelper.addToList(this.item_input, item_input_1, item_input_2, item_input_3, item_input_4);
        RecipeHelper.addToList(this.item_output, item_output_1, item_output_2);
        this.cook_time = Math.max(0, cook_time);
        this.require_lid = false;
        this.catalyst_slot = -1;
        this.catalyst = ItemStack.field_190927_a;
        this.bottle = ItemStack.field_190927_a;
        this.bucket = ItemStack.field_190927_a;
    }

    public CauldronRecipe(int cook_time, FluidStack fluid_input, FluidStack fluid_output, List<ItemStack> item_input_1, List<ItemStack> item_input_2, List<ItemStack> item_input_3, ItemStack item_output_1, ItemStack item_output_2) {
        this(cook_time, fluid_input, fluid_output, item_input_1, item_input_2, item_input_3, null, item_output_1, item_output_2);
    }

    public CauldronRecipe(int cook_time, FluidStack fluid_input, FluidStack fluid_output, List<ItemStack> item_input_1, List<ItemStack> item_input_2, ItemStack item_output_1, ItemStack item_output_2) {
        this(cook_time, fluid_input, fluid_output, item_input_1, item_input_2, null, null, item_output_1, item_output_2);
    }

    public CauldronRecipe(int cook_time, FluidStack fluid_input, FluidStack fluid_output, List<ItemStack> item_input_1, ItemStack item_output_1, ItemStack item_output_2) {
        this(cook_time, fluid_input, fluid_output, item_input_1, null, null, null, item_output_1, item_output_2);
    }

    public CauldronRecipe(int cook_time, FluidStack fluid_input, FluidStack fluid_output, ItemStack item_input_1, ItemStack item_input_2, ItemStack item_input_3, ItemStack item_input_4, ItemStack item_output_1, ItemStack item_output_2) {
        this(cook_time, fluid_input, fluid_output, RecipeHelper.buildList(item_input_1), RecipeHelper.buildList(item_input_2), RecipeHelper.buildList(item_input_3), RecipeHelper.buildList(item_input_4), item_output_1, item_output_2);
    }

    @Override
    public CauldronRecipe setCatalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        this.catalyst_slot = this.matchCatalystIngredient(this.item_input);
        return this;
    }

    @Override
    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getCatalystSlot() {
        return this.catalyst_slot;
    }

    public FluidStack getFluidInput() {
        return this.fluid_input != null ? this.fluid_input.copy() : null;
    }

    public FluidStack getFluidOutput() {
        return this.fluid_output != null ? this.fluid_output.copy() : null;
    }

    public List<List<ItemStack>> getInput() {
        return this.item_input;
    }

    public List<ItemStack> getOutput() {
        return this.item_output;
    }

    public int getCookTime() {
        return this.cook_time;
    }

    public boolean hasItemInput() {
        return this.item_input.size() > 0;
    }

    public boolean hasItemOut() {
        return this.item_output.size() > 0;
    }

    public boolean hasFluidInput() {
        return this.fluid_input != null;
    }

    public boolean hasFluidOutput() {
        return this.fluid_output != null && this.fluid_output.amount > 0 && !this.fluid_output.isFluidEqual(this.fluid_input);
    }

    public boolean matches(TileCauldron tile, boolean match_iterations) {
        if (this.isDisabled()) {
            PrimalAPI.logger(23, RECIPE_PREFIX, "recipe is disabled");
            return false;
        }
        if (this.requiresLid() && !tile.isCovered()) {
            PrimalAPI.logger(23, RECIPE_PREFIX, "recipe requires lid");
            return false;
        }
        if (this.hasCatalyst() && !this.isCatalystIngredient() && !tile.hasInput(this.catalyst)) {
            PrimalAPI.logger(23, RECIPE_PREFIX, "recipe: " + this.getRegistryName() + ", failed catalyst check: " + this.catalyst);
            return false;
        }
        FluidTank tank = tile.getTank();
        FluidStack cauldron_fluid = tile.getContainedFluid(true);
        if (this.hasFluidInput()) {
            FluidStack recipe_fluid = this.getFluidInput();
            if (tile.hasFluid(recipe_fluid)) {
                PrimalAPI.logger(23, RECIPE_PREFIX, "fluid is matched amounts: " + cauldron_fluid.amount + ":" + recipe_fluid.amount);
                int recipe_count = this.getInput().size();
                if (recipe_count > 0) {
                    List<ItemStack> tile_slots = RecipeHelper.buildList(tile.getInputHandler());
                    int iterations = this.hasFluidOutput() && match_iterations ? cauldron_fluid.amount / recipe_fluid.amount : 1;
                    int match_count = 0;
                    block0: for (List<ItemStack> recipe_slots : this.getInput()) {
                        for (ItemStack recipe_slot_item : recipe_slots) {
                            for (ItemStack tile_slot_item : tile_slots) {
                                PrimalAPI.logger(23, RECIPE_PREFIX, "items: " + tile_slot_item.func_77977_a() + ":" + recipe_slot_item.func_77977_a());
                                if (!StackHelper.containsStack(tile_slot_item, StackHelper.multipleStack(recipe_slot_item, iterations)) && (!this.hasCatalyst() || !this.isCatalystIngredient() || !this.matchCatalyst(tile_slot_item))) continue;
                                ++match_count;
                                tile_slots.remove(tile_slot_item);
                                continue block0;
                            }
                        }
                    }
                    PrimalAPI.logger(23, RECIPE_PREFIX, "fluid + item recipe count: " + recipe_count + ":" + match_count);
                    return match_count == recipe_count && (!this.hasItemOut() || tile.canStoreOutput(this.getOutput()));
                }
                PrimalAPI.logger(23, RECIPE_PREFIX, "fluid only recipe match: " + recipe_count + ":" + this.fluid_output);
                return true;
            }
            PrimalAPI.logger(23, RECIPE_PREFIX, "failed fluid match");
            return false;
        }
        if (tank.canFillFluidType(this.getFluidOutput())) {
            PrimalAPI.logger(23, RECIPE_PREFIX, "matching item based recipe");
            int recipe_count = this.getInput().size();
            if (recipe_count > 0) {
                List<ItemStack> tile_slots = RecipeHelper.buildList(tile.getInputHandler());
                int match_count = 0;
                block3: for (List<ItemStack> recipe_slots : this.getInput()) {
                    for (ItemStack recipe_slot_item : recipe_slots) {
                        for (ItemStack tile_slot_item : tile_slots) {
                            PrimalAPI.logger(23, RECIPE_PREFIX, "items: " + tile_slot_item.func_77977_a() + " (" + recipe_slot_item.func_190916_E() + "):" + recipe_slot_item.func_77977_a() + " (" + recipe_slot_item.func_190916_E() + "), " + StackHelper.containsStack(tile_slot_item, recipe_slot_item));
                            if (!StackHelper.containsStack(tile_slot_item, recipe_slot_item) && (!this.hasCatalyst() || !this.isCatalystIngredient() || !this.matchCatalyst(tile_slot_item))) continue;
                            ++match_count;
                            tile_slots.remove(tile_slot_item);
                            continue block3;
                        }
                    }
                }
                PrimalAPI.logger(23, RECIPE_PREFIX, "item only recipe count: " + recipe_count + ":" + match_count);
                return match_count == recipe_count && (!this.hasItemOut() || tile.canStoreOutput(this.getOutput()));
            }
        }
        PrimalAPI.logger(23, RECIPE_PREFIX, "matching failed");
        return false;
    }

    public CauldronRecipe setRequiresLid(boolean require_lid) {
        this.require_lid = require_lid;
        return this;
    }

    public boolean requiresLid() {
        return this.require_lid;
    }

    public CauldronRecipe setBottle(ItemStack bottle) {
        this.bottle = bottle;
        return this;
    }

    public CauldronRecipe setBucket(ItemStack bucket) {
        this.bucket = bucket;
        return this;
    }

    public ItemStack getBottle() {
        return this.bottle;
    }

    public ItemStack getBucket() {
        return this.bucket;
    }

    public List<FluidStack> listFluidInput() {
        return new ArrayList<FluidStack>(Arrays.asList(this.getFluidInput()));
    }

    public List<FluidStack> listFluidOutput() {
        return new ArrayList<FluidStack>(Arrays.asList(this.getFluidOutput()));
    }
}

