/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.tile;

import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.common.helper.RecipeHelper;
import nmd.primal.core.common.recipes.AbstractRecipe;
import nmd.primal.core.common.tiles.machines.TileBrickMold;

public class BrickRecipe
extends AbstractRecipe<BrickRecipe> {
    public static final String RECIPE_PREFIX = "brick";
    public static final IForgeRegistry<BrickRecipe> REGISTRY = GameRegistry.findRegistry(BrickRecipe.class);
    public static final Collection<BrickRecipe> RECIPES = REGISTRY.getValuesCollection();
    private final List<ItemStack> input;
    private final ItemStack output;

    public BrickRecipe(List<ItemStack> input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public BrickRecipe(ItemStack input, ItemStack output) {
        this(RecipeHelper.buildList(input), output);
    }

    public BrickRecipe(Item input, Item output) {
        this(RecipeHelper.buildList(new ItemStack(input)), new ItemStack(output));
    }

    public boolean matches(ItemStack stack) {
        if (!this.isDisabled()) {
            for (ItemStack match : this.getInput()) {
                if (!match.func_77969_a(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(TileBrickMold tile) {
        ItemStackHandler handler;
        if (this.isDisabled()) {
            return false;
        }
        if (tile.hasCraftingItems() && (handler = tile.getCraftingHandler()) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!this.matches(handler.getStackInSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

