/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.recipes.inworld;

import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import nmd.primal.core.common.recipes.AbstractRecipe;

public class BottleRecipe
extends AbstractRecipe<BottleRecipe> {
    public static final String RECIPE_PREFIX = "bottle";
    public static final IForgeRegistry<BottleRecipe> REGISTRY = GameRegistry.findRegistry(BottleRecipe.class);
    public static final Collection<BottleRecipe> RECIPES = REGISTRY.getValuesCollection();
    private final FluidStack input;
    private final ItemStack output;
    private boolean is_disabled;
    private boolean is_hidden;

    public BottleRecipe(FluidStack input, ItemStack output) {
        this.input = input;
        this.output = output;
        this.is_disabled = false;
        this.is_hidden = false;
    }

    @Override
    public BottleRecipe setDisabled(boolean is_disabled) {
        this.is_disabled = is_disabled;
        return this;
    }

    @Override
    public BottleRecipe setHidden(boolean is_hidden) {
        this.is_hidden = is_hidden;
        return this;
    }

    @Override
    public boolean isDisabled() {
        return this.is_disabled;
    }

    @Override
    public boolean isHidden() {
        return this.is_hidden;
    }

    public FluidStack getInput() {
        return this.input.copy();
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean match(ItemStack output) {
        for (BottleRecipe recipe : RECIPES) {
            if (!output.func_77969_a(recipe.output)) continue;
            return true;
        }
        return false;
    }

    public static BottleRecipe getRecipe(FluidStack fluid) {
        for (BottleRecipe recipe : RECIPES) {
            if (!fluid.isFluidEqual(recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public static BottleRecipe getRecipe(ItemStack output) {
        for (BottleRecipe recipe : RECIPES) {
            if (!output.func_77969_a(recipe.output)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isOutput(ItemStack output) {
        for (BottleRecipe recipe : RECIPES) {
            if (!output.func_77969_a(recipe.output)) continue;
            return true;
        }
        return false;
    }
}

